/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.tagsupport;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.tagsupport.TypedComponentSymbolDelegate;
import oracle.eclipse.tools.application.common.services.tagsupport.TypedSymbolDelegate;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.ELModelObjectSubExpression;
import oracle.eclipse.tools.webtier.jsf.tagsupport.IFaceletTagSymbolFactory;
import oracle.eclipse.tools.webtier.jsf.tagsupport.Messages;
import oracle.eclipse.tools.webtier.jsf.variable.FaceletDataModelVariableFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.designtime.symbols.JSFSymbolFactory;
import org.eclipse.osgi.util.NLS;

public class FaceletSymbolFactory
implements IFaceletTagSymbolFactory {
    private static final List<String> SUPPORTED_URIS = Collections.unmodifiableList(Arrays.asList("http://java.sun.com/jsf/core", "http://java.sun.com/jsf/html", "http://java.sun.com/jsf/facelets"));

    @Override
    public ISymbol create(String symbolName, int scope, DesignTimeContextData.TagRange declaringTag, DesignTimeContextData.AttributeRange declaringAttribute, IDocument doc) {
        return this.handleSymbolCreation(symbolName, declaringTag, declaringAttribute, doc.getProject(), doc);
    }

    private ISymbol handleSymbolCreation(String symbolName, DesignTimeContextData.TagRange tagRange, DesignTimeContextData.AttributeRange declaringAttribute, Project proj, IDocument doc) {
        String uri = tagRange.getTagIdentifier().getUri();
        if ("http://java.sun.com/jsf/core".equals(uri)) {
            return this.handleCoreTags(symbolName, tagRange, declaringAttribute, proj, doc);
        }
        if ("http://java.sun.com/jsf/html".equals(uri)) {
            return this.handleHtmlTags(symbolName, tagRange, declaringAttribute, proj, doc);
        }
        if ("http://java.sun.com/jsf/facelets".equals(uri)) {
            return this.handleFaceletTags(symbolName, tagRange, declaringAttribute, proj, doc);
        }
        return null;
    }

    private ISymbol handleFaceletTags(String symbolName, DesignTimeContextData.TagRange tagRange, DesignTimeContextData.AttributeRange declaringAttribute, Project proj, IDocument doc) {
        String elementName = tagRange.getTagIdentifier().getName();
        String attrName = declaringAttribute.getName();
        if ("repeat".equals(elementName)) {
            if ("var".equalsIgnoreCase(attrName)) {
                FaceletDataModelVariableFactory factory;
                DesignTimeContextData.ELRange elRange;
                ISymbol symbol = null;
                DesignTimeContextData.AttributeRange valueAttr = tagRange.getAttribute("value");
                if (valueAttr != null && (elRange = (factory = new FaceletDataModelVariableFactory()).getSingleSubexpression(valueAttr)) != null) {
                    ELModelObjectSubExpression elModelObjectSubExpression = (ELModelObjectSubExpression)elRange.getModelSubExprs().get(0);
                    int offset = elRange.getStartOffset();
                    symbol = new FaceletDataModelVariableFactory().createSymbolForDataTableValue(symbolName, elModelObjectSubExpression, (IModelContext)new FilePositionContext(offset, doc.getFile()));
                    symbol = new TypedSymbolDelegate(symbol);
                    ((TypedSymbolDelegate)symbol).setDOMNode((IAdaptable)new IFaceletTagSymbolFactory.NodeAdaptable(declaringAttribute));
                }
                if (symbol == null) {
                    symbol = new JSFSymbolFactory().createDefaultSymbol(symbolName, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, "");
                }
                return symbol;
            }
            if ("varstatus".equalsIgnoreCase(attrName)) {
                IProject iProj = proj.getEclipseProject();
                IJavaProject javaProject = JavaCore.create((IProject)iProj);
                return new JSFSymbolFactory().createScalarSymbol(symbolName, "I", ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, javaProject);
            }
        }
        return null;
    }

    private ISymbol handleHtmlTags(String symbolName, DesignTimeContextData.TagRange tagRange, DesignTimeContextData.AttributeRange declaringAttribute, Project proj, IDocument doc) {
        String elementName = tagRange.getTagIdentifier().getName();
        String attrName = declaringAttribute.getName();
        if ("dataTable".equals(elementName) && "var".equals(attrName)) {
            FaceletDataModelVariableFactory factory;
            DesignTimeContextData.ELRange elRange;
            ISymbol symbol = null;
            DesignTimeContextData.AttributeRange valueAttr = tagRange.getAttribute("value");
            if (valueAttr != null && (elRange = (factory = new FaceletDataModelVariableFactory()).getSingleSubexpression(valueAttr)) != null) {
                ELModelObjectSubExpression elModelObjectSubExpression = (ELModelObjectSubExpression)elRange.getModelSubExprs().get(0);
                int offset = elRange.getStartOffset();
                symbol = new FaceletDataModelVariableFactory().createSymbolForDataTableValue(symbolName, elModelObjectSubExpression, (IModelContext)new FilePositionContext(offset, doc.getFile()));
                symbol = new TypedSymbolDelegate(symbol);
                ((TypedSymbolDelegate)symbol).setDOMNode((IAdaptable)new IFaceletTagSymbolFactory.NodeAdaptable(declaringAttribute));
            }
            if (symbol == null) {
                symbol = new JSFSymbolFactory().createDefaultSymbol(symbolName, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, "");
            }
            return symbol;
        }
        return null;
    }

    private ISymbol handleCoreTags(String symbolName, DesignTimeContextData.TagRange tagRange, DesignTimeContextData.AttributeRange declaringAttribute, Project proj, IDocument doc) {
        String elementName = tagRange.getTagIdentifier().getName();
        if ("loadBundle".equals(elementName)) {
            return this.handleLoadBundleTag(symbolName, tagRange, declaringAttribute, proj);
        }
        if ("selectItems".equals(elementName)) {
            return this.handleSelectItems(symbolName, tagRange, declaringAttribute, proj, doc);
        }
        return null;
    }

    private ISymbol handleSelectItems(String symbolName, DesignTimeContextData.TagRange tagRange, DesignTimeContextData.AttributeRange declaringAttribute, Project proj, IDocument doc) {
        String attrName = declaringAttribute.getName();
        if ("var".equals(attrName)) {
            FaceletDataModelVariableFactory factory;
            DesignTimeContextData.ELRange elRange;
            ISymbol symbol = null;
            DesignTimeContextData.AttributeRange valueAttr = tagRange.getAttribute("value");
            if (valueAttr != null && (elRange = (factory = new FaceletDataModelVariableFactory()).getSingleSubexpression(valueAttr)) != null) {
                ELModelObjectSubExpression elModelObjectSubExpression = (ELModelObjectSubExpression)elRange.getModelSubExprs().get(0);
                int offset = elRange.getStartOffset();
                symbol = new FaceletDataModelVariableFactory().createSymbolForDataTableValue(symbolName, elModelObjectSubExpression, (IModelContext)new FilePositionContext(offset, doc.getFile()));
                symbol = new TypedSymbolDelegate(symbol);
                ((TypedSymbolDelegate)symbol).setDOMNode((IAdaptable)new IFaceletTagSymbolFactory.NodeAdaptable(declaringAttribute));
            }
            if (symbol == null) {
                symbol = new JSFSymbolFactory().createDefaultSymbol(symbolName, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, "");
            }
            return symbol;
        }
        return null;
    }

    private ISymbol handleLoadBundleTag(String symbolName, DesignTimeContextData.TagRange tagRange, DesignTimeContextData.AttributeRange declaringAttribute, Project proj) {
        DesignTimeContextData.AttributeRange baseNameAttr;
        String attrName = declaringAttribute.getName();
        if ("var".equals(attrName) && (baseNameAttr = tagRange.getAttribute("basename")) != null) {
            String basename = baseNameAttr.getAttr().getValue();
            IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
            symbol.setName(symbolName);
            symbol.setDetailedDescription(NLS.bind((String)Messages.JSFSymbolFactory_detail, (Object)basename));
            TypedComponentSymbolDelegate typedSymbol = new TypedComponentSymbolDelegate(symbol);
            if (proj != null) {
                DataType bundleType = this.getBundleDataType(proj, basename, tagRange);
                typedSymbol.setDataType(bundleType);
                typedSymbol.setDOMNode((IAdaptable)new IFaceletTagSymbolFactory.NodeAdaptable(baseNameAttr));
                return typedSymbol;
            }
        }
        return new JSFSymbolFactory().createDefaultSymbol(symbolName, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, "");
    }

    private DataType getBundleDataType(Project project, String basename, DesignTimeContextData.TagRange owningElement) {
        IDatatypeProvider dtp = (IDatatypeProvider)project.getAppService(IDatatypeProvider.class);
        if (dtp != null) {
            IDataTypeIntrospector introspector = dtp.getIntrospector();
            return new JavaResourceBundleDataType(introspector, project, basename);
        }
        throw new IllegalStateException("Web app must have a data type provider");
    }

    @Override
    public List<String> getSupportedUris() {
        return SUPPORTED_URIS;
    }
}

