/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.tagsupport;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.tagsupport.TypedComponentSymbolDelegate;
import oracle.eclipse.tools.application.common.services.tagsupport.TypedSymbolDelegate;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.ELModelObjectSubExpression;
import oracle.eclipse.tools.webtier.jsf.tagsupport.IFaceletTagSymbolFactory;
import oracle.eclipse.tools.webtier.jsf.variable.FaceletDataModelVariableFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;

public class FaceletJSTLSymbolFactory
implements IFaceletTagSymbolFactory {
    private static final String HTTP_JAVA_SUN_COM_JSP_JSTL_CORE = "http://java.sun.com/jsp/jstl/core";

    @Override
    public ISymbol create(String symbolName, int scope, DesignTimeContextData.TagRange declaringTag, DesignTimeContextData.AttributeRange declaringAttribute, IDocument document) {
        ISymbol symbol = this.handleSymbolCreation(symbolName, declaringTag, declaringAttribute, document);
        return symbol;
    }

    @Override
    public List<String> getSupportedUris() {
        return Collections.singletonList(HTTP_JAVA_SUN_COM_JSP_JSTL_CORE);
    }

    private ISymbol handleSymbolCreation(String symbolName, DesignTimeContextData.TagRange declaringTag, DesignTimeContextData.AttributeRange declaringAttribute, IDocument document) {
        String uri = declaringTag.getTagIdentifier().getUri();
        ISymbol symbol = null;
        if (HTTP_JAVA_SUN_COM_JSP_JSTL_CORE.equals(uri)) {
            symbol = this.handleCoreTags(symbolName, declaringAttribute, declaringTag, document);
        }
        return symbol;
    }

    private ISymbol getDefaultSymbol(String symbolName, DesignTimeContextData.AttributeRange attr) {
        IComponentSymbol cSymbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        cSymbol.setName(symbolName);
        cSymbol.setRuntimeSource(ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL);
        TypedComponentSymbolDelegate symbol = new TypedComponentSymbolDelegate(cSymbol);
        symbol.setDOMNode((IAdaptable)new IFaceletTagSymbolFactory.NodeAdaptable(attr));
        return symbol;
    }

    private ISymbol handleCoreTags(String symbolName, DesignTimeContextData.AttributeRange attr, DesignTimeContextData.TagRange declaringElement, IDocument document) {
        ISymbol symbol = null;
        String declaringTagName = declaringElement.getTagIdentifier().getName();
        if ("forEach".equals(declaringTagName)) {
            if ("var".equals(attr.getName())) {
                symbol = this.handleCoreForEachTag(symbolName, attr, declaringElement, document);
            }
        } else if ("set".equals(declaringTagName)) {
            symbol = this.handleCoreSetTag(symbolName, attr, declaringElement, document);
        }
        if (symbol == null) {
            symbol = this.getDefaultSymbol(symbolName, attr);
        }
        return symbol;
    }

    private ISymbol handleCoreSetTag(String symbolName, DesignTimeContextData.AttributeRange attr, DesignTimeContextData.TagRange owningElement, IDocument document) {
        return this.createSymbol(symbolName, "value", owningElement, attr, document);
    }

    private ISymbol handleCoreForEachTag(String symbolName, DesignTimeContextData.AttributeRange attr, DesignTimeContextData.TagRange declaringElement, IDocument document) {
        ISymbol symbol = this.createSymbol(symbolName, "items", declaringElement, attr, document);
        if (symbol != null) {
            symbol = new TypedSymbolDelegate(symbol);
            ((TypedSymbolDelegate)symbol).setDOMNode((IAdaptable)new IFaceletTagSymbolFactory.NodeAdaptable(attr));
            return symbol;
        }
        return null;
    }

    private ISymbol createSymbol(String name, String valueAttrName, DesignTimeContextData.TagRange declaringTag, DesignTimeContextData.AttributeRange attr, IDocument doc) {
        FaceletDataModelVariableFactory factory;
        DesignTimeContextData.ELRange elRange;
        String value;
        DesignTimeContextData.AttributeRange valueAttr = declaringTag.getAttribute(valueAttrName);
        ISymbol symbol = null;
        if (valueAttr != null && (value = valueAttr.getAttr().getValue()) != null && (elRange = (factory = new FaceletDataModelVariableFactory()).getSingleSubexpression(valueAttr)) != null) {
            ELModelObjectSubExpression elModelObjectSubExpression = (ELModelObjectSubExpression)elRange.getModelSubExprs().get(0);
            int offset = elRange.getStartOffset();
            symbol = new FaceletDataModelVariableFactory().createSymbolForDataTableValue(name, elModelObjectSubExpression, (IModelContext)new FilePositionContext(offset, doc.getFile()));
            symbol = new TypedSymbolDelegate(symbol);
            ((TypedSymbolDelegate)symbol).setDOMNode((IAdaptable)new IFaceletTagSymbolFactory.NodeAdaptable(attr));
        }
        return symbol;
    }
}

