/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.refactoring.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.refactoring.BundleRefactoringUtil;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.webtier.jsf.refactoring.internal.JsfRefactoringUtil;
import oracle.eclipse.tools.webtier.jsf.refactoring.internal.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;

public class MessageBundleMoveParticipant
extends MoveParticipant {
    private IFile fileToMove;
    private Set<IFile> bundlesToMove = new HashSet<IFile>();
    private Set<IArtifactReference> referencesToProcess = new HashSet<IArtifactReference>();
    private String oldReferenceName;

    protected boolean initialize(Object element) {
        IArtifact artifact = RefactoringUtil.elementToArtifact((Object)element);
        if (artifact instanceof ResourceArtifact && artifact.getLocation() != null && artifact.getLocation().getResource() instanceof IFile && BundleRefactoringUtil.isBundleFile((IResource)artifact.getLocation().getResource()) && JavaUtil.isJavaPackage((IContainer)artifact.getLocation().getResource().getParent())) {
            this.fileToMove = (IFile)artifact.getLocation().getResource();
            this.oldReferenceName = JsfRefactoringUtil.getFullyQualifiedFileName(this.fileToMove);
            if (BundleRefactoringUtil.isBundleFile((IResource)this.fileToMove) && this.getArguments().getDestination() != null) {
                ArtifactController controller = ArtifactControllerFactory.getController();
                Project project = (Project)this.fileToMove.getProject().getAdapter(Project.class);
                IAppLocalizer appService = (IAppLocalizer)project.getAppService(IAppLocalizer.class);
                Set allBaseNames = appService.getAllBaseNames();
                for (String baseName : allBaseNames) {
                    String fullName = JsfRefactoringUtil.getFullyQualifiedFileName(this.fileToMove);
                    if (!fullName.startsWith(baseName)) continue;
                    Collection availableLocales = appService.getAvailableLocales(baseName);
                    for (Locale locale : availableLocales) {
                        IBundleResource bundle = appService.resolveBundle(baseName, locale);
                        if (bundle == null) continue;
                        IFile bundleFile = bundle.getUnderlyingResource();
                        IArtifact a = RefactoringUtil.ensureResourceArtifact((IResource)bundleFile);
                        Set artifactReferers = controller.getArtifactReferers(a);
                        this.referencesToProcess.addAll(artifactReferers);
                        this.bundlesToMove.add(bundle.getUnderlyingResource());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public String getName() {
        return Messages.MessageBundleMoveParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (this.getArguments().getDestination() instanceof IContainer) {
            IContainer destination = (IContainer)this.getArguments().getDestination();
            String destinationPackage = JavaUtil.getPackageName((IContainer)destination);
            if (destinationPackage == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.MessageBundleMoveParticipant_destinationIsNotInClasspath);
            }
            return new RefactoringStatus();
        }
        return RefactoringStatus.createFatalErrorStatus((String)Messages.MessageBundleMoveParticipant_destinationNotContainer);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange(Messages.MessageBundleMoveParticipant_moveLocalizedBundles);
        String newReferenceName = JsfRefactoringUtil.getFullyQualifiedFileName((IContainer)this.getArguments().getDestination(), this.fileToMove.getName());
        RefactoringUtil.createChangesForArtifactReferences((RefactoringProcessor)this.getProcessor(), (CompositeChange)compositeChange, this.referencesToProcess, (String)this.oldReferenceName, (String)newReferenceName, new HashMap());
        IContainer destination = (IContainer)this.getArguments().getDestination();
        for (IFile messageBundle : this.bundlesToMove) {
            if (messageBundle.equals((Object)this.fileToMove)) continue;
            MoveResourceChange change = new MoveResourceChange((IResource)messageBundle, destination);
            compositeChange.add((Change)change);
        }
        return compositeChange;
    }
}

