/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.refactoring.internal;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.webtier.jsf.Activator;
import oracle.eclipse.tools.webtier.jsf.refactoring.internal.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class FacesConfigRefactoringHelper {
    private static final String PATTERN = "\n{0}<context-param>\n{1}<param-name>javax.faces.CONFIG_FILES</param-name>\n{2}<param-value>/{3}</param-value>\n{4}</context-param>";

    public static IContainer getWebContentResource(IProject project) {
        IVirtualFolder rootFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc != null && (rootFolder = vc.getRootFolder()) != null) {
            return rootFolder.getUnderlyingFolder();
        }
        return null;
    }

    public static boolean hasWebXmlReferenceFor(IFile facesConfig) {
        Object adaptedArtifact = facesConfig.getAdapter(IArtifact.class);
        if (adaptedArtifact instanceof IArtifact) {
            ArtifactController controller = ArtifactControllerFactory.getController();
            Set referers = controller.getArtifactReferers((IArtifact)adaptedArtifact);
            for (IArtifactReference reference : referers) {
                Set locations;
                IResource resource;
                IArtifact owner = reference.getOwner();
                if (!(owner instanceof ResourceArtifact) || !(resource = ((ResourceArtifact)owner).getLocation().getResource()).getName().equals("web.xml") || (locations = reference.getLocations()) == null || locations.size() <= 0) continue;
                Range range = null;
                for (IArtifactReferenceLocation location : locations) {
                    ResourceLocation resourceLocation = location.getResourceLocation();
                    if (resourceLocation == null || (range = resourceLocation.getRange()) == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static IFile getWebXmlFile(IFile facesConfiguration) {
        Object adaptedArtifact = facesConfiguration.getAdapter(IArtifact.class);
        if (adaptedArtifact instanceof IArtifact) {
            ArtifactController controller = ArtifactControllerFactory.getController();
            Set referers = controller.getArtifactReferers((IArtifact)adaptedArtifact);
            for (IArtifactReference reference : referers) {
                IResource resource;
                IArtifact owner = reference.getOwner();
                if (!(owner instanceof ResourceArtifact) || !(resource = ((ResourceArtifact)owner).getLocation().getResource()).getName().equals("web.xml")) continue;
                return (IFile)resource;
            }
        }
        return null;
    }

    public static String createDocumentFragment(IPath facesConfigPath) {
        String path = facesConfigPath.toString();
        return MessageFormat.format(PATTERN, "\t", "\t\t", "\t\t", path, "\t");
    }

    public static Change createChangeForWebXml(IPath facesConfigPath, IFile webXml) {
        Visitor visitor;
        block10: {
            IVisitableDOMModel model = null;
            visitor = new Visitor();
            try {
                model = StructuredModelFactory.getVisitableModelForRead((IFile)webXml);
                model.accept((IStructuredXMLModelVisitor)visitor);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "oracle.eclipse.tools.webtier.jsf", e.getMessage(), (Throwable)e));
                if (model != null) {
                    model.dispose();
                }
                break block10;
            }
            catch (IOException e) {
                try {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "oracle.eclipse.tools.webtier.jsf", e.getMessage(), (Throwable)e));
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (model != null) {
                        model.dispose();
                    }
                }
            }
            if (model == null) break block10;
            model.dispose();
        }
        if (visitor.offset > 0) {
            TextFileChange textEdit = new TextFileChange(Messages.FacesConfigRenameParticipant_registrationWebXml, webXml);
            String text = FacesConfigRefactoringHelper.createDocumentFragment(facesConfigPath);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textEdit.setEdit((TextEdit)multiTextEdit);
            multiTextEdit.addChild((TextEdit)new InsertEdit(visitor.offset, text));
            return textEdit;
        }
        return null;
    }

    static class Visitor
    implements IStructuredXMLModelVisitor {
        int offset = -1;

        Visitor() {
        }

        public boolean visit(IDOMAttr attribute) {
            return false;
        }

        public boolean visit(IDOMDocument document) {
            return true;
        }

        public boolean visit(IDOMElement element) {
            String name = element.getLocalName();
            if (name.equals("web-app")) {
                this.offset = element.getStartEndOffset();
                return false;
            }
            return true;
        }

        public boolean visit(IDOMNode node) {
            return false;
        }
    }
}

