/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.refactoring.internal;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.TypeArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.TypePropertyReference;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanProperty;
import oracle.eclipse.tools.webtier.jsf.refactoring.internal.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class BeanPropertyRenameParticipant
extends RenameParticipant {
    private IType type;
    private IMethod method;
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String BOOLEAN_GETTER_PREFIX = "is";
    private Set<IArtifact> artifactsToRename = new HashSet<IArtifact>();
    private Set<IArtifact> methodArtifactsToRename = new HashSet<IArtifact>();
    private String oldPropertyName;
    private String newPropertyName;
    private String oldMethodName;
    private String newMethodName;
    private boolean isOldGeneric = false;
    private boolean isNewGeneric = false;
    private boolean isFieldRename = false;

    protected boolean initialize(Object element) {
        if (element instanceof IMethod) {
            this.method = (IMethod)element;
            RefactoringProcessor processor = this.getProcessor();
            if (!this.checkUpdatesEnabled(processor)) {
                return false;
            }
            this.oldMethodName = this.method.getElementName();
            this.newMethodName = this.getArguments().getNewName();
            String processorClassName = processor.getClass().getName();
            if (processorClassName.equals("org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor")) {
                this.isFieldRename = true;
                if (this.oldMethodName.startsWith(SETTER_PREFIX)) {
                    return false;
                }
            }
            this.type = this.method.getDeclaringType();
            Set<TypeArtifact> typeArtifacts = this.findTypeArtifacts();
            for (TypeArtifact typeArtifact : typeArtifacts) {
                this.oldPropertyName = this.resolvePropertyName(this.oldMethodName);
                this.isOldGeneric = this.isGenericMethod(this.oldMethodName);
                this.newPropertyName = this.getArguments().getNewName();
                this.isNewGeneric = this.isGenericMethod(this.newPropertyName);
                this.newPropertyName = this.resolvePropertyName(this.newPropertyName);
                ArtifactController controller = ArtifactControllerFactory.getController();
                Set artifactReferences = controller.getArtifactReferers((IArtifact)typeArtifact);
                for (IArtifactReference reference : artifactReferences) {
                    IArtifact property;
                    IArtifact owner = reference.getOwner();
                    if (owner instanceof TypePropertyReference) {
                        if (((TypePropertyReference)owner).getName().equals(this.oldPropertyName)) {
                            if (this.isOldGeneric || !this.isNewGeneric) {
                                this.artifactsToRename.add(owner);
                            }
                        } else if (!this.isFieldRename && ((TypePropertyReference)owner).getName().equals(this.oldMethodName)) {
                            this.methodArtifactsToRename.add(owner);
                        }
                    }
                    if (!(owner instanceof ManagedBeanArtifact) || !((property = DependencyModelManager.getInstance().getModel().queryArtifactsByOwnerNameAndType(owner, this.oldPropertyName, "managed-property")) instanceof ManagedBeanProperty) || this.isNewGeneric) continue;
                    ManagedBeanProperty managedProp = (ManagedBeanProperty)property;
                    this.artifactsToRename.add((IArtifact)managedProp);
                }
            }
        }
        return !this.artifactsToRename.isEmpty() || !this.methodArtifactsToRename.isEmpty();
    }

    private boolean checkUpdatesEnabled(RefactoringProcessor processor) {
        try {
            Object bool;
            Method updateMethod = processor.getClass().getMethod("getUpdateReferences", new Class[0]);
            if (updateMethod != null && (bool = updateMethod.invoke((Object)processor, new Object[0])) != null && bool instanceof Boolean) {
                return (Boolean)bool;
            }
        }
        catch (Exception exception) {}
        return true;
    }

    private boolean isGenericMethod(String propName) {
        return propName == null || propName.length() < 3 || !propName.startsWith(GETTER_PREFIX) && !propName.startsWith(BOOLEAN_GETTER_PREFIX) && !propName.startsWith(SETTER_PREFIX);
    }

    private Set<TypeArtifact> findTypeArtifacts() {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        HashSet<TypeArtifact> results = new HashSet<TypeArtifact>();
        TypeArtifact typeArtifact = (TypeArtifact)this.type.getAdapter(IArtifact.class);
        if (typeArtifact != null) {
            results.add(typeArtifact);
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.type.getJavaProject().getProject());
        this.findAllReferences(model, results, component);
        return results;
    }

    private void findAllReferences(IDependencyModel model, Set<TypeArtifact> results, IVirtualComponent component) {
        IVirtualComponent[] references;
        HashSet<IProject> traversedProjects = new HashSet<IProject>();
        traversedProjects.add(component.getProject());
        IVirtualComponent[] iVirtualComponentArray = references = component.getReferencingComponents();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference[] virtualReferences;
            IVirtualComponent cp = iVirtualComponentArray[n2];
            IProject project = cp.getProject();
            this.findAndAddTypeArtifact(model, results, project, traversedProjects);
            IVirtualReference[] iVirtualReferenceArray = virtualReferences = cp.getReferences();
            int n3 = virtualReferences.length;
            int n4 = 0;
            while (n4 < n3) {
                IVirtualReference virtualReference = iVirtualReferenceArray[n4];
                IProject p = virtualReference.getReferencedComponent().getProject();
                this.findAndAddTypeArtifact(model, results, p, traversedProjects);
                ++n4;
            }
            ++n2;
        }
    }

    private void findAndAddTypeArtifact(IDependencyModel model, Set<TypeArtifact> results, IProject project, Set<IProject> traversedProjects) {
        if (!traversedProjects.contains(project)) {
            traversedProjects.add(project);
            TypeArtifact artifact = (TypeArtifact)model.queryArtifactsByOwnerNameAndType((IArtifact)model.ensureResourceArtifact((IResource)project), this.type.getFullyQualifiedName(), "type");
            if (artifact != null) {
                results.add(artifact);
            }
        }
    }

    private String resolvePropertyName(String oldPropName) {
        String resolvedProperty = oldPropName;
        if (oldPropName.startsWith(SETTER_PREFIX) || oldPropName.startsWith(GETTER_PREFIX)) {
            resolvedProperty = StringUtil.lowerCaseFirstLetter((String)resolvedProperty.substring(3));
        } else if (oldPropName.startsWith(BOOLEAN_GETTER_PREFIX)) {
            resolvedProperty = StringUtil.lowerCaseFirstLetter((String)resolvedProperty.substring(2));
        }
        return resolvedProperty;
    }

    public String getName() {
        return Messages.BeanPropertyRenameParticipant_participantName;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        String getter;
        IMethod getterMethod;
        RefactoringStatus status = new RefactoringStatus();
        String methodName = this.method.getElementName();
        if (methodName.startsWith(GETTER_PREFIX) || methodName.startsWith(BOOLEAN_GETTER_PREFIX)) {
            String setter = methodName.startsWith(GETTER_PREFIX) ? SETTER_PREFIX + methodName.substring(3) : SETTER_PREFIX + methodName.substring(2);
            IMethod getterMethod2 = this.type.getMethod(methodName, new String[0]);
            IMethod setterMethod = null;
            try {
                setterMethod = this.type.getMethod(setter, new String[]{getterMethod2.getReturnType()});
            }
            catch (JavaModelException javaModelException) {}
            if (setterMethod != null && setterMethod.exists() && !this.isFieldRename) {
                status.addWarning(Messages.BeanPropertyRenameParticipant_getterMethodRenameWarning);
            }
        } else if (methodName.startsWith(SETTER_PREFIX) && (getterMethod = this.type.getMethod(getter = GETTER_PREFIX + methodName.substring(3), new String[0])).exists()) {
            status.addWarning(Messages.BeanPropertyRenameParticipant_setterMethodRenameWarning);
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.method.getElementName().startsWith(SETTER_PREFIX) && this.oldPropertyName != null && !this.oldPropertyName.equals(this.newPropertyName)) {
            CompositeChange change = new CompositeChange(Messages.BeanPropertyRenameParticipant_participantName);
            if (this.artifactsToRename.size() > 0) {
                RefactoringUtil.createChangesForArtifact((RefactoringProcessor)this.getProcessor(), (CompositeChange)change, this.artifactsToRename, (String)this.oldPropertyName, (String)this.newPropertyName);
            }
            if (this.methodArtifactsToRename.size() > 0) {
                RefactoringUtil.createChangesForArtifact((RefactoringProcessor)this.getProcessor(), (CompositeChange)change, this.methodArtifactsToRename, (String)this.oldMethodName, (String)this.newMethodName);
            }
            return change;
        }
        return null;
    }
}

