/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.model.html;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Target implements Enumerator
{
    _SELF(0, "_self", "_self"),
    _BLANK(1, "_blank", "_blank"),
    _PARENT(2, "_parent", "_parent"),
    _TOP(3, "_top", "_top");

    public static final int _SELF_VALUE = 0;
    public static final int _BLANK_VALUE = 1;
    public static final int _PARENT_VALUE = 2;
    public static final int _TOP_VALUE = 3;
    private static final Target[] VALUES_ARRAY;
    public static final List<Target> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Target[]{_SELF, _BLANK, _PARENT, _TOP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Target get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Target result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Target getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Target result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Target get(int value) {
        switch (value) {
            case 0: {
                return _SELF;
            }
            case 1: {
                return _BLANK;
            }
            case 2: {
                return _PARENT;
            }
            case 3: {
                return _TOP;
            }
        }
        return null;
    }

    private Target(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

