/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.model.html;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LinkType implements Enumerator
{
    ALTERNATE(0, "Alternate", "Alternate"),
    STYLESHEET(1, "Stylesheet", "Stylesheet"),
    START(2, "Start", "Start"),
    NEXT(3, "Next", "Next"),
    PREV(4, "Prev", "Prev"),
    CONTENTS(5, "Contents", "Contents"),
    INDEX(6, "Index", "Index"),
    GLOSSARY(7, "Glossary", "Glossary"),
    COPYRIGHT(8, "Copyright", "Copyright"),
    CHAPTER(9, "Chapter", "Chapter"),
    SECTION(10, "Section", "Section"),
    SUBSECTION(11, "Subsection", "Subsection"),
    APPENDIX(12, "Appendix", "Appendix"),
    HELP(13, "Help", "Help"),
    BOOKMARK(14, "Bookmark", "Bookmark");

    public static final int ALTERNATE_VALUE = 0;
    public static final int STYLESHEET_VALUE = 1;
    public static final int START_VALUE = 2;
    public static final int NEXT_VALUE = 3;
    public static final int PREV_VALUE = 4;
    public static final int CONTENTS_VALUE = 5;
    public static final int INDEX_VALUE = 6;
    public static final int GLOSSARY_VALUE = 7;
    public static final int COPYRIGHT_VALUE = 8;
    public static final int CHAPTER_VALUE = 9;
    public static final int SECTION_VALUE = 10;
    public static final int SUBSECTION_VALUE = 11;
    public static final int APPENDIX_VALUE = 12;
    public static final int HELP_VALUE = 13;
    public static final int BOOKMARK_VALUE = 14;
    private static final LinkType[] VALUES_ARRAY;
    public static final List<LinkType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LinkType[]{ALTERNATE, STYLESHEET, START, NEXT, PREV, CONTENTS, INDEX, GLOSSARY, COPYRIGHT, CHAPTER, SECTION, SUBSECTION, APPENDIX, HELP, BOOKMARK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LinkType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LinkType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LinkType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LinkType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LinkType get(int value) {
        switch (value) {
            case 0: {
                return ALTERNATE;
            }
            case 1: {
                return STYLESHEET;
            }
            case 2: {
                return START;
            }
            case 3: {
                return NEXT;
            }
            case 4: {
                return PREV;
            }
            case 5: {
                return CONTENTS;
            }
            case 6: {
                return INDEX;
            }
            case 7: {
                return GLOSSARY;
            }
            case 8: {
                return COPYRIGHT;
            }
            case 9: {
                return CHAPTER;
            }
            case 10: {
                return SECTION;
            }
            case 11: {
                return SUBSECTION;
            }
            case 12: {
                return APPENDIX;
            }
            case 13: {
                return HELP;
            }
            case 14: {
                return BOOKMARK;
            }
        }
        return null;
    }

    private LinkType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

