/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.model.html;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Frame implements Enumerator
{
    NONE(0, "none", "none"),
    ABOVE(1, "above", "above"),
    BELOW(2, "below", "below"),
    HSIDES(3, "hsides", "hsides"),
    VSIDES(4, "vsides", "vsides"),
    LHS(5, "lhs", "lhs"),
    RHS(6, "rhs", "rhs"),
    BOX(7, "box", "box"),
    BORDER(8, "border", "border");

    public static final int NONE_VALUE = 0;
    public static final int ABOVE_VALUE = 1;
    public static final int BELOW_VALUE = 2;
    public static final int HSIDES_VALUE = 3;
    public static final int VSIDES_VALUE = 4;
    public static final int LHS_VALUE = 5;
    public static final int RHS_VALUE = 6;
    public static final int BOX_VALUE = 7;
    public static final int BORDER_VALUE = 8;
    private static final Frame[] VALUES_ARRAY;
    public static final List<Frame> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Frame[]{NONE, ABOVE, BELOW, HSIDES, VSIDES, LHS, RHS, BOX, BORDER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Frame get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Frame result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Frame getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Frame result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Frame get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return ABOVE;
            }
            case 2: {
                return BELOW;
            }
            case 3: {
                return HSIDES;
            }
            case 4: {
                return VSIDES;
            }
            case 5: {
                return LHS;
            }
            case 6: {
                return RHS;
            }
            case 7: {
                return BOX;
            }
            case 8: {
                return BORDER;
            }
        }
        return null;
    }

    private Frame(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

