/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.model.facestagbase;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OnOffType implements Enumerator
{
    ON(0, "on", "on"),
    OFF(1, "off", "off");

    public static final int ON_VALUE = 0;
    public static final int OFF_VALUE = 1;
    private static final OnOffType[] VALUES_ARRAY;
    public static final List<OnOffType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OnOffType[]{ON, OFF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OnOffType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OnOffType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OnOffType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OnOffType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OnOffType get(int value) {
        switch (value) {
            case 0: {
                return ON;
            }
            case 1: {
                return OFF;
            }
        }
        return null;
    }

    private OnOffType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

