/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.model.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DateStyle implements Enumerator
{
    DEFAULT(0, "default", "default"),
    SHORT(1, "short", "short"),
    MEDIUM(2, "medium", "medium"),
    LONG(3, "long", "long"),
    FULL(4, "full", "full");

    public static final int DEFAULT_VALUE = 0;
    public static final int SHORT_VALUE = 1;
    public static final int MEDIUM_VALUE = 2;
    public static final int LONG_VALUE = 3;
    public static final int FULL_VALUE = 4;
    private static final DateStyle[] VALUES_ARRAY;
    public static final List<DateStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DateStyle[]{DEFAULT, SHORT, MEDIUM, LONG, FULL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DateStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DateStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DateStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DateStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DateStyle get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return SHORT;
            }
            case 2: {
                return MEDIUM;
            }
            case 3: {
                return LONG;
            }
            case 4: {
                return FULL;
            }
        }
        return null;
    }

    private DateStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

