/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.locale;

import java.util.Collections;
import java.util.Locale;
import oracle.eclipse.tools.application.common.services.collection.AbstractLocalizationDiscoveryParticipant;
import oracle.eclipse.tools.application.common.services.documentservices.DOMUtil;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.jsf.internal.TraceOptions;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;

public final class JsfLocalizationDiscoveryParticipant
extends AbstractLocalizationDiscoveryParticipant {
    private static final String ID = JsfLocalizationDiscoveryParticipant.class.getName();
    private static final boolean DEBUG = TraceOptions.JSF_LOCALIZATION_DISCOVERY;

    public JsfLocalizationDiscoveryParticipant() {
        this(new AbstractLocalizationDiscoveryParticipant.LocalizationInjectableDependencies("jsf", DEBUG));
    }

    public JsfLocalizationDiscoveryParticipant(AbstractLocalizationDiscoveryParticipant.LocalizationInjectableDependencies dependencies) {
        super(ID, dependencies);
    }

    protected AbstractLocalizationDiscoveryParticipant.LocalizationVisitor createVisitor() {
        return new MyVisitor(this.getDependencies());
    }

    protected AbstractLocalizationDiscoveryParticipant.LocalizationVisitor doDiscover(IVisitableDOMModel model) {
        Integer localCounter = counter++;
        if (this.getDependencies().isDebugEnabled()) {
            System.out.printf("JSF Localization: begin discovery (%d)\n", localCounter);
        }
        AbstractLocalizationDiscoveryParticipant.LocalizationVisitor visitor = super.doDiscover(model);
        if (this.getDependencies().isDebugEnabled()) {
            System.out.printf("JSF Localization: end discovery (%d)\n", localCounter);
        }
        return visitor;
    }

    private static class MyVisitor
    extends AbstractLocalizationDiscoveryParticipant.LocalizationVisitor {
        private MyVisitor(AbstractLocalizationDiscoveryParticipant.LocalizationInjectableDependencies deps) {
            super(deps);
        }

        public boolean visit(IDOMElement element) {
            Locale locale = this.getTagOverridenLocale(this.getDependencies().getDocument(), element);
            if (locale != null) {
                Range range = this._rangeFactory.createRange(element);
                this.addLocaleRange(range, range, locale);
            }
            return true;
        }

        private Locale getTagOverridenLocale(IDocument doc, IDOMElement element) {
            DOMUtil domUtil = this.getDependencies().getDomUtil();
            if (domUtil.isNode(doc, (Node)element, Collections.singletonList("http://java.sun.com/jsf/core"), "view")) {
                String localeValue = domUtil.getAttributeValue((Node)element, "locale");
                ValueReferenceELParser parser = new ValueReferenceELParser();
                if (localeValue != null) {
                    if (parser.getELExpression(localeValue) == null) {
                        return new Locale(localeValue.trim());
                    }
                    return (Locale)this.getDependencies().getLocales().getOverrideValue();
                }
            }
            return null;
        }
    }
}

