/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.locale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.common.services.webapp.JavaLocalizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultLocaleType;
import org.eclipse.jst.jsf.facesconfig.emf.LocaleConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.SupportedLocaleType;

public class FacesLocalizer
extends JavaLocalizer {
    public FacesLocalizer(Project project) {
        super(project);
    }

    public String getDefaultBaseName() {
        return null;
    }

    public Collection<String> getBaseNames() {
        return Collections.emptyList();
    }

    public Locale resolveLocale(List<Locale> preferredLocales) {
        return this.calculateLocale(preferredLocales);
    }

    private Locale calculateLocale(List<Locale> preferredLocales) {
        Locale result = null;
        IJSFAppConfigManager manager = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)this._project);
        if (manager == null) {
            return null;
        }
        List applications = manager.getApplications();
        List<LocaleConfigType> configs = this.getAllLocaleConfigs(applications);
        for (Locale preferred : preferredLocales) {
            result = this.findMatch(configs, preferred);
            if (result != null) break;
        }
        if (result == null) {
            List<Locale> defaultLocales = this.getDefaultLocales(configs);
            if (defaultLocales.size() == 0) {
                return Locale.getDefault();
            }
            result = defaultLocales.get(0);
        }
        return result;
    }

    private Locale findMatch(List<LocaleConfigType> configs, Locale preferred) {
        Locale result = null;
        block0: for (LocaleConfigType localeConfig : configs) {
            for (SupportedLocaleType localeType : localeConfig.getSupportedLocale()) {
                List<Locale> defaultLocales;
                String supportedLocaleText = localeType.getTextContent();
                if (supportedLocaleText == null) continue;
                Locale supportedLocale = FacesLocalizer.parse((String)supportedLocaleText.trim());
                if (preferred.equals(supportedLocale)) {
                    result = supportedLocale;
                    continue block0;
                }
                if (preferred.getLanguage().equals(supportedLocale.getLanguage()) && supportedLocale.getCountry().length() == 0) {
                    result = supportedLocale;
                }
                if (result != null || (defaultLocales = this.getDefaultLocales(configs)).size() == 0) continue;
                Locale defaultLocale = defaultLocales.get(0);
                if (preferred.equals(defaultLocale)) {
                    result = defaultLocale;
                    continue block0;
                }
                if (!preferred.getLanguage().equals(defaultLocale.getLanguage()) || defaultLocale.getCountry().length() != 0) continue;
                result = defaultLocale;
            }
        }
        return result;
    }

    private List<Locale> getDefaultLocales(List<LocaleConfigType> configs) {
        ArrayList<Locale> defaultLocales = new ArrayList<Locale>();
        for (LocaleConfigType config : configs) {
            String defaultLocalString;
            DefaultLocaleType defaultLocaleType = config.getDefaultLocale();
            if (defaultLocaleType == null || (defaultLocalString = defaultLocaleType.getTextContent()) == null) continue;
            defaultLocales.add(FacesLocalizer.parse((String)defaultLocalString));
        }
        return defaultLocales;
    }

    private final List<LocaleConfigType> getAllLocaleConfigs(List applications) {
        ArrayList<LocaleConfigType> configs = new ArrayList<LocaleConfigType>();
        for (ApplicationType application : applications) {
            Iterator localeConfigIt = application.getLocaleConfig().iterator();
            while (localeConfigIt.hasNext()) {
                configs.add((LocaleConfigType)localeConfigIt.next());
            }
        }
        return Collections.unmodifiableList(configs);
    }
}

