/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.jsp.document;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.MethodReferenceFactory;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IVisitableDocument;
import oracle.eclipse.tools.webtier.jsf.document.FaceletXhtmlNamespaceContextFactory;
import oracle.eclipse.tools.webtier.jsp.variables.JDTCodeVarAnalyzer;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContextFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class FacesJSPUtil {
    public static boolean isFacesTag(EObject tagElement) {
        return true;
    }

    public static boolean isFacesPage(IDocument document) {
        IVisitableDocument visitable = (IVisitableDocument)document.getAdapter(IVisitableDocument.class);
        INamespaceContextFactory contextFactory = (INamespaceContextFactory)document.getAdapter(INamespaceContextFactory.class);
        if (visitable != null && contextFactory != null) {
            if (contextFactory instanceof FaceletXhtmlNamespaceContextFactory) {
                return true;
            }
            FacesPageVisitor visitor = new FacesPageVisitor(contextFactory.getNamespaceContext(document.getFile()));
            visitable.accept((IStructuredXMLModelVisitor)visitor);
            return visitor.isFacesPage();
        }
        return false;
    }

    public static String viewIdFromFile(IFile file) {
        IVirtualResource[] vResources = ComponentCore.createResources((IResource)file);
        return vResources[0].getRuntimePath().toString();
    }

    public static Set<String> getActionOutcomes(IFile file, IDOMElement owningElement, IDOMAttr attribute) {
        MethodReference methodRef;
        IDocument doc = (IDocument)file.getAdapter(IDocument.class);
        if (doc != null && (methodRef = FacesJSPUtil.getMethodReferenceFromAttribute(doc, owningElement, attribute)) != null && methodRef.getMethodReturnType() != null && !methodRef.getMethodReturnType().isUnknown()) {
            IMethod method = FacesJSPUtil.getJavaMethod(file.getProject(), methodRef);
            JDTCodeVarAnalyzer cva = new JDTCodeVarAnalyzer();
            return cva.getReturnStringLiterals(method, file.getProject());
        }
        return Collections.emptySet();
    }

    private static IMethod getJavaMethod(IProject project, MethodReference methodRef) {
        String[] methodParams = FacesJSPUtil.getParamsAsStrings(methodRef);
        String methodName = methodRef.getMethodName();
        String clazz = FacesJSPUtil.getClassType(methodRef);
        String[] methodParamSigs = new String[]{};
        if (methodParams != null) {
            methodParamSigs = new String[methodParams.length];
            int i = 0;
            while (i < methodParams.length) {
                methodParamSigs[i] = Signature.createTypeSignature((String)methodParams[i], (boolean)true);
                ++i;
            }
        }
        try {
            IJavaProject jProj = JavaCore.create((IProject)project);
            IType type = jProj.findType(clazz);
            return type.getMethod(methodName, methodParamSigs);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static String getClassType(MethodReference methodRef) {
        ValueReference valRef = methodRef.getValueReference();
        DataType type = valRef.getType(DataType.NullModelContext.getInstance());
        return type.getName();
    }

    private static String[] getParamsAsStrings(MethodReference methodRef) {
        List paramTypes = methodRef.getMethodParameterTypes();
        String[] params = new String[paramTypes.size()];
        int i = 0;
        while (i < paramTypes.size()) {
            DataType type = (DataType)paramTypes.get(i);
            params[i] = type.getName();
            ++i;
        }
        return params;
    }

    public static boolean isVisibleValueRef(ValueReference valRef) {
        if (valRef.getVariable().getResolutionType() == ResolutionTime.PAGE_COMPILE) {
            return false;
        }
        Variable.SCOPE scope = valRef.getVariable().getScope();
        return scope == Variable.SCOPE.SESSION_SCOPE || scope == Variable.SCOPE.REQUEST_SCOPE || scope == Variable.SCOPE.APPLICATION_SCOPE;
    }

    private static MethodReference getMethodReferenceFromAttribute(IDocument doc, IDOMElement owningElement, IDOMAttr attribute) {
        ValueReferenceELParser parser = new ValueReferenceELParser();
        String elExpression = attribute.getNodeValue();
        ELExpression parsedELExpression = parser.getELExpression(elExpression);
        if (parsedELExpression != null) {
            DocumentVariableQuery varQuery = new DocumentVariableQuery(doc, -1);
            MethodReferenceFactory factory = new MethodReferenceFactory();
            List methodRefs = factory.createMethodReference(parsedELExpression.getElText(), (VariableQuery)varQuery);
            return methodRefs == null || methodRefs.size() != 1 ? null : (MethodReference)methodRefs.get(0);
        }
        return null;
    }

    private static class FacesPageVisitor
    implements IStructuredXMLModelVisitor {
        private boolean _isFacesPage = false;
        private final INamespaceContext _nsContext;

        public FacesPageVisitor(INamespaceContext nsContext) {
            this._nsContext = nsContext;
        }

        public boolean visit(IDOMNode node) {
            return !this._isFacesPage;
        }

        public boolean visit(IDOMAttr attribute) {
            return !this._isFacesPage;
        }

        public boolean visit(IDOMElement element) {
            if (this._isFacesPage) {
                return false;
            }
            TagIdentifier tagId = TagIdentifierFactory.createJSPTagWrapper((String)this._nsContext.getNamespace((Node)element), (String)element.getLocalName());
            if (tagId.equals((Object)IJSFConstants.TAG_IDENTIFIER_VIEW) || tagId.equals((Object)IJSFConstants.TAG_IDENTIFIER_SUBVIEW)) {
                this._isFacesPage = true;
                return false;
            }
            return true;
        }

        public boolean visit(IDOMDocument document) {
            return true;
        }

        public boolean isFacesPage() {
            return this._isFacesPage;
        }
    }
}

