/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelets.validation;

import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import org.eclipse.core.resources.IFile;

public abstract class XmlFilePositionContext
extends FilePositionContext {
    public XmlFilePositionContext(int startOffset, IFile file) {
        super(startOffset, file);
    }

    public abstract DesignTimeContextData.TagRange getParent();

    public abstract String getValue();

    public abstract String getLocalName();

    public abstract String getNamespaceUri();

    public static class XmlAttrFilePositionContext
    extends XmlFilePositionContext {
        private DesignTimeContextData.AttributeRange attrRange;

        public XmlAttrFilePositionContext(IFile file, DesignTimeContextData.AttributeRange attrRange) {
            super(attrRange.getValueRange() != null ? attrRange.getValueRange().getStartOffset() : -1, file);
            this.attrRange = attrRange;
        }

        public DesignTimeContextData.AttributeRange getAttr() {
            return this.attrRange;
        }

        @Override
        public DesignTimeContextData.TagRange getParent() {
            return this.attrRange.getParent();
        }

        @Override
        public String getValue() {
            return this.attrRange.getAttr().getValue();
        }

        @Override
        public String getLocalName() {
            return this.attrRange.getAttr().getLocalName();
        }

        @Override
        public String getNamespaceUri() {
            return this.attrRange.getAttr().getNamespace();
        }
    }

    public static class XmlElementFilePositionContext
    extends XmlFilePositionContext {
        private DesignTimeContextData.TagRange tagRange;

        public XmlElementFilePositionContext(IFile file, DesignTimeContextData.TagRange tagRange) {
            super(tagRange.getStartOffset(), file);
            this.tagRange = tagRange;
        }

        public DesignTimeContextData.TagRange getTagRange() {
            return this.tagRange;
        }

        @Override
        public DesignTimeContextData.TagRange getParent() {
            return this.tagRange.getParent();
        }

        @Override
        public String getValue() {
            return null;
        }

        @Override
        public String getLocalName() {
            return this.tagRange.getTagIdentifier().getName();
        }

        @Override
        public String getNamespaceUri() {
            return this.tagRange.getTagIdentifier().getUri();
        }
    }
}

