/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelets.validation;

import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.faces.view.Location;
import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.application.common.services.el.ELUtil;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.javawebapp.Activator;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.ELModelObjectSubExpression;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.IdentifierSubexpression;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.ParseError;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TagError;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.XMLTextRange;
import oracle.eclipse.tools.webtier.jsf.facelets.FaceletCompileUtil;
import oracle.eclipse.tools.webtier.jsf.facelets.validation.XmlFilePositionContext;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.DelegatingInstanceSymbol;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.DelegatingPropertySymbol;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.InstanceSymbolDelegate;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.PropertySymbolDelegate;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.SymbolDelegate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper2;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.symbol.IMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.resolver.ISymbolContextResolver;
import org.eclipse.jst.jsf.designtime.resolver.StructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidationMessage;
import org.eclipse.jst.jsf.validation.internal.ELValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.JSFTypeComparatorPreferences;
import org.eclipse.jst.jsf.validation.internal.Severity;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;

public class OepeFaceletViewValidator {
    private Severity memberNotFoundSeverity;
    private ValidationPreferences prefs = new ValidationPreferences(JSFCorePlugin.getDefault().getPreferenceStore());
    private ELValidationPreferences elPrefs;
    private int memberNotFoundSeverityInt;

    public OepeFaceletViewValidator() {
        this.prefs.load();
        this.elPrefs = this.prefs.getElPrefs();
        this.memberNotFoundSeverity = this.elPrefs.getSeverity(ELValidationPreferences.MEMBER_NOT_FOUND);
        this.memberNotFoundSeverityInt = this.convertSeverity(this.memberNotFoundSeverity);
    }

    public void validate(IFile file, IJSFViewValidator.IValidationReporter jsfReporter) {
        if (FaceletCompileUtil.isInValidCompileState()) {
            return;
        }
        JSFTypeComparatorPreferences typeComparatorPrefs = this.prefs.getTypeComparatorPrefs();
        DesignTimeContext context = FaceletCompileUtil.ensureContext(file);
        FilePositionContext fileContext = new FilePositionContext(file);
        if (context == null) {
            Activator.log((Throwable)new Exception("Context returned null for " + file));
            return;
        }
        DesignTimeContextData data = context.getData();
        for (Map.Entry entrySet : data.getTagRanges().entrySet()) {
            List tags = (List)entrySet.getValue();
            for (DesignTimeContextData.TagRange tag : tags) {
                for (DesignTimeContextData.AttributeRange attrRange : tag.getAttributes()) {
                    if (attrRange.getELRanges().isEmpty()) {
                        this.validateNonELAttributeValue(file, attrRange, jsfReporter);
                        continue;
                    }
                    if (!this.elPrefs.isEnableBuildValidation()) continue;
                    this.validateELAttributeValue((IFilePositionContext)fileContext, attrRange, jsfReporter, typeComparatorPrefs);
                }
            }
        }
        for (DesignTimeContextData.ELRange elTextRange : data.getElTextRanges()) {
            ISymbolContextResolver symbolContextResolver = StructuredDocumentSymbolResolverFactory.getInstance().getSymbolContextResolver((IModelContext)fileContext);
            this.validateELRange((IFilePositionContext)fileContext, elTextRange.getStartOffset(), elTextRange.getELText(), jsfReporter, symbolContextResolver, elTextRange);
        }
        for (ParseError parseError : data.getParseErrors()) {
            this.reportValidationMessage(this.createValidationMessage(2, parseError.getLocalizedMessage(), file), jsfReporter, parseError.getCharacterOffset(), "");
        }
        for (TagError tagError : data.getTagErrors()) {
            int startOffset = tagError.getStartOffset();
            int length = tagError.getEndOffset() - tagError.getStartOffset();
            DesignTimeContextData.TagRange associatedRange = data.getTagRangeFor(tagError);
            if (associatedRange != null) {
                startOffset = associatedRange.getStartOffset();
                length = associatedRange.getEndOffsetOpenTag() - associatedRange.getStartOffset();
            }
            this.reportValidationMessage(this.createValidationMessage(2, tagError.getLocalizedMessage(), file), jsfReporter, startOffset, length);
        }
    }

    private void validateELAttributeValue(IFilePositionContext context, DesignTimeContextData.AttributeRange attrRange, IJSFViewValidator.IValidationReporter jsfReporter, JSFTypeComparatorPreferences typeComparatorPrefs) {
        Severity methodExpressionSeverity;
        ISymbolContextResolver symbolContextResolver = StructuredDocumentSymbolResolverFactory.getInstance().getSymbolContextResolver((IModelContext)context);
        ISymbol lastMember = null;
        for (DesignTimeContextData.ELRange elRange : attrRange.getELRanges()) {
            lastMember = this.validateELRange(context, attrRange.getValueRange().getStartOffset(), attrRange.getAttr().getValue(), jsfReporter, symbolContextResolver, elRange);
        }
        if (lastMember != null && attrRange.getELRanges().size() == 1 && (methodExpressionSeverity = typeComparatorPrefs.getSeverity(JSFTypeComparatorPreferences.METHOD_EXPRESSION_EXPECTED)) != Severity.IGNORE) {
            this.validateMethodExpression(context, attrRange, lastMember, this.convertSeverity(methodExpressionSeverity), jsfReporter);
        }
    }

    private ISymbol validateELRange(IFilePositionContext context, int startOffset, String validationText, IJSFViewValidator.IValidationReporter jsfReporter, ISymbolContextResolver symbolContextResolver, DesignTimeContextData.ELRange elRange) {
        ISymbol lastMember = null;
        if (!elRange.getErrors().isEmpty()) {
            for (ELException error : elRange.getErrors()) {
                this.reportValidationMessage(this.createValidationMessage(this.convertSeverity(this.elPrefs.getSeverity(ELValidationPreferences.GENERAL_SYNTAX_ERROR)), error.getLocalizedMessage(), context.getFile()), jsfReporter, startOffset, validationText);
            }
        }
        List modelSubExprs = elRange.getModelSubExprs();
        for (ELModelObjectSubExpression subExpr : modelSubExprs) {
            ISymbol variable = ELUtil.getVariable((IModelContext)context, (String)subExpr.getModelObjectName().getName());
            if (variable == null || this.memberNotFoundSeverity == Severity.IGNORE) continue;
            lastMember = this.validateMembers(context, jsfReporter, symbolContextResolver, subExpr, variable);
        }
        return lastMember;
    }

    private void validateMethodExpression(IFilePositionContext context, DesignTimeContextData.AttributeRange attrRange, ISymbol lastMember, int severity, IJSFViewValidator.IValidationReporter jsfReporter) {
        Object value;
        IMetaDataDomainContext mdContext = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(context.getFile());
        IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery(mdContext);
        DesignTimeContextData.TagRange parent = attrRange.getParent();
        String entityKey = String.valueOf(parent.getTagIdentifier().getName()) + "/" + attrRange.getAttr().getLocalName();
        Entity entity = query.getQueryHelper().getEntity(parent.getTagIdentifier().getUri(), entityKey);
        Trait trait = query.getQueryHelper().getTrait(entity, "attribute-value-runtime-type");
        if (trait != null && ("org.eclipse.jst.jsf.core.attributevalues.MethodBindingType".equals(value = new TraitValueHelper2().getValue(trait)) || "oracle.eclipse.tools.adf.view.attributevalues.ActionType".equals(value)) && !(lastMember instanceof IMethodSymbol)) {
            this.reportValidationMessage(this.createValidationMessage(severity, "Method expression expected", context.getFile()), jsfReporter, attrRange.getValueRange().getStartOffset(), attrRange.getAttr().getValue());
        }
    }

    private ISymbol validateMembers(IFilePositionContext context, IJSFViewValidator.IValidationReporter jsfReporter, ISymbolContextResolver symbolContextResolver, ELModelObjectSubExpression subExpr, ISymbol variable) {
        ISymbol curObjSymbol = variable;
        for (IdentifierSubexpression prop : subExpr.getPropertyObjectNames()) {
            if (this.isNotValidatable(curObjSymbol)) {
                return null;
            }
            ISymbol nextSymbol = symbolContextResolver.getProperty(curObjSymbol, (Object)prop.getName());
            if (nextSymbol == null) {
                if (curObjSymbol instanceof IObjectSymbol) {
                    nextSymbol = symbolContextResolver.getMethod((IObjectSymbol)curObjSymbol, (Object)prop.getName());
                }
                if (nextSymbol == null) {
                    this.reportValidationMessage(this.createValidationMessage(this.memberNotFoundSeverityInt, String.format("Couldn't find member %s", prop.getName()), context.getFile()), jsfReporter, prop.getStartOffset(), prop.getName());
                    return null;
                }
            }
            curObjSymbol = nextSymbol;
        }
        return curObjSymbol;
    }

    private boolean isNotValidatable(ISymbol curObjSymbol) {
        DataType.Field field;
        SymbolDelegate delegate;
        if (curObjSymbol instanceof DelegatingInstanceSymbol) {
            Variable variable;
            SymbolDelegate delegate2 = ((DelegatingInstanceSymbol)curObjSymbol).getDelegate();
            if (delegate2 instanceof InstanceSymbolDelegate && (variable = ((InstanceSymbolDelegate)delegate2).getVariable()) != null) {
                return this.isDataTypeNotValidatable(variable.getType());
            }
        } else if (curObjSymbol instanceof DelegatingPropertySymbol && (delegate = ((DelegatingPropertySymbol)curObjSymbol).getDelegate()) instanceof PropertySymbolDelegate && (field = ((PropertySymbolDelegate)delegate).getField()) != null) {
            return this.isDataTypeNotValidatable(field.getType());
        }
        return false;
    }

    private boolean isDataTypeNotValidatable(DataType type) {
        return type == null || type.isMap() || type.isUnknown() || type.isUnspecified();
    }

    private int convertSeverity(Severity severity) {
        switch (severity) {
            case ERROR: {
                return 4;
            }
            case WARNING: {
                return 2;
            }
        }
        return -1;
    }

    private void validateNonELAttributeValue(IFile file, DesignTimeContextData.AttributeRange attributeRange, IJSFViewValidator.IValidationReporter reporter) {
        if (!attributeRange.getELRanges().isEmpty()) {
            return;
        }
        Location location = attributeRange.getAttr().getLocation();
        String path = location.getPath();
        IFile fileForLocation = this.getFileForLocation(file.getProject(), path);
        if (!file.equals((Object)fileForLocation)) {
            return;
        }
        XmlFilePositionContext.XmlAttrFilePositionContext context = new XmlFilePositionContext.XmlAttrFilePositionContext(file, attributeRange);
        DesignTimeContextData.TagRange parent = attributeRange.getParent();
        String uri = parent.getTagIdentifier().getUri();
        String tagName = parent.getTagIdentifier().getName();
        String attrName = attributeRange.getAttr().getLocalName();
        List vv = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors2(IValidValues.class, (IModelContext)context, uri, tagName, attrName);
        if (!vv.isEmpty()) {
            String attributeValue = attributeRange.getAttr().getValue();
            for (IValidValues v : vv) {
                if (v.isValidValue(attributeValue.trim())) continue;
                for (IValidationMessage msg : v.getValidationMessages()) {
                    if (msg == null) continue;
                    XMLTextRange valueRange = attributeRange.getValueRange();
                    this.reportValidationMessage(this.createValidationMessage(msg.getSeverity(), msg.getMessage(), file), reporter, valueRange != null ? valueRange.getStartOffset() : -1, attributeValue);
                }
            }
        }
    }

    private IFile getFileForLocation(IProject project, String path) {
        IResource resourceForPath;
        IWebRootResolver appService;
        Project adapter = (Project)project.getAdapter(Project.class);
        if (adapter != null && (appService = (IWebRootResolver)adapter.getAppService(IWebRootResolver.class)) != null && (resourceForPath = appService.getResourceForPath(path)) != null && resourceForPath.getType() == 1) {
            return (IFile)resourceForPath;
        }
        return null;
    }

    private void reportValidationMessage(Diagnostic problem, IJSFViewValidator.IValidationReporter reporter, int startOffset, String attributeValue) {
        int start = startOffset;
        int length = attributeValue.length();
        reporter.report(problem, start, length);
    }

    private void reportValidationMessage(Diagnostic problem, IJSFViewValidator.IValidationReporter reporter, int startOffset, int length) {
        int start = startOffset;
        reporter.report(problem, start, length);
    }

    private Diagnostic createValidationMessage(int severity, String msg, IFile file) {
        BasicDiagnostic diagnostic = new BasicDiagnostic(severity, "", -1, msg, null);
        return diagnostic;
    }
}

