/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelets;

import java.io.IOException;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.core.internal.impl.ParamValueImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebAppLoader {
    private IProject project;

    public WebAppLoader(IProject project) {
        this.project = project;
    }

    public List<ParamValue> getWebAppParamValues() {
        IFile file;
        IResource root = IWebRootResolver.Util.getRoot((IProject)this.project);
        if (root != null && root instanceof IContainer && (file = ((IContainer)root).getFile((IPath)new Path("WEB-INF/web.xml"))) != null && file.isAccessible()) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                SAXParser saxParser = factory.newSAXParser();
                WebAppDefaultHandler hb = new WebAppDefaultHandler();
                saxParser.parse(file.getContents(), (DefaultHandler)hb);
                return hb.getParamValues();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                return Collections.emptyList();
            }
            catch (SAXException sAXException) {
                return Collections.emptyList();
            }
            catch (IOException iOException) {
                return Collections.emptyList();
            }
            catch (CoreException coreException) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private static class WebAppDefaultHandler
    extends DefaultHandler {
        private Deque<String> elementStack;
        private LinkedList<ParamValue> paramValues;

        private WebAppDefaultHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.elementStack = new LinkedList<String>();
            this.elementStack.push("");
        }

        public List<ParamValue> getParamValues() {
            return this.paramValues == null ? Collections.EMPTY_LIST : this.paramValues;
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.elementStack != null) {
                this.elementStack.clear();
                this.elementStack = null;
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.handle(uri, qName, attributes);
            this.elementStack.push(qName);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.elementStack.pop();
        }

        private void handle(String uri, String localName, Attributes attributes) {
            if ("context-param".equals(localName) && "web-app".equals(this.elementStack.peek())) {
                if (this.paramValues == null) {
                    this.paramValues = new LinkedList();
                }
                ParamValueImpl paramValue = new ParamValueImpl(){};
                this.paramValues.push((ParamValue)paramValue);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if ("param-name".equals(this.elementStack.peek())) {
                ParamValue paramValue = this.paramValues.peek();
                String paramName = paramValue.getParamName();
                paramName = String.valueOf(paramName == null ? "" : paramName) + new String(ch, start, length);
                paramValue.setParamName(paramName);
            } else if ("param-value".equals(this.elementStack.peek())) {
                ParamValue paramValue = this.paramValues.peek();
                String paramVal = paramValue.getParamValue();
                paramVal = String.valueOf(paramVal == null ? "" : paramVal) + new String(ch, start, length);
                paramValue.setParamValue(paramVal);
            }
        }
    }
}

