/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelets;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.jsf.Activator;
import oracle.eclipse.tools.webtier.jsf.facelet.DTFaceletCompilerExecutor;
import oracle.eclipse.tools.webtier.jsf.facelet.FaceletCompilerConfigurator;
import oracle.eclipse.tools.webtier.jsf.facelet.URLHandler;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;
import oracle.eclipse.tools.webtier.jsf.facelets.FaceletAdaptingLibrary;
import oracle.eclipse.tools.webtier.jsf.facelets.IFaceletCompiler;
import org.apache.myfaces.view.facelets.tag.CompositeTagLibrary;
import org.apache.myfaces.view.facelets.tag.TagLibrary;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jst.jsf.common.internal.managedobject.AbstractManagedObject;
import org.eclipse.jst.jsf.core.internal.CompositeTagRegistryFactory;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;

public class OepeFaceletCompiler
extends AbstractManagedObject
implements IFaceletCompiler {
    private IProject project;
    private URL dtd;
    private static final String HTMLSOURCE_CONTENT_TYPE_ID = "org.eclipse.wst.html.core.htmlsource";

    public OepeFaceletCompiler(IProject project, URL dtd) {
        this.project = project;
        this.dtd = dtd;
    }

    public synchronized void dispose() {
        if (!this.isDisposed()) {
            super.dispose();
            this.project = null;
        }
    }

    public void destroy() {
    }

    public void checkpoint() {
    }

    @Override
    public DesignTimeContext compile(IFile file) {
        block8: {
            IAppClassLoaderProvider.IClassLoader loader = this.getClassLoader(this.project);
            if (loader != null) {
                try {
                    FaceletCompilerConfigurator.DTFaceletCompilerConfig config;
                    IWebRootResolver resolver = this.getResolver(this.project);
                    if (resolver == null || (config = this.createConfig(file, loader, resolver)) == null) break block8;
                    DTFaceletCompilerExecutor executor = new DTFaceletCompilerExecutor(config);
                    try {
                        executor.execute();
                        DesignTimeContext designTimeContext = DesignTimeContext.getCurrentInstance();
                        return designTimeContext;
                    }
                    catch (IOException e) {
                        Activator.log(e);
                    }
                }
                finally {
                    if (loader != null) {
                        loader.close();
                    }
                }
            }
        }
        return null;
    }

    private FaceletCompilerConfigurator.DTFaceletCompilerConfig createConfig(IFile file, IAppClassLoaderProvider.IClassLoader loader, IWebRootResolver rootResolver) {
        URL targetFile = this.getFileURL(file);
        URL rootDir = this.getRootDir(rootResolver);
        Project proj = (Project)this.project.getAdapter(Project.class);
        if (targetFile != null && rootDir != null && proj != null) {
            DesignTimeContext dtContext = new DesignTimeContext(targetFile);
            dtContext.setResourceKey((Object)file);
            FaceletCompilerConfigurator.DTFaceletCompilerConfig configure = new FaceletCompilerConfigurator().configure(rootDir, targetFile, dtContext, loader.getClassLoader(), new URLHandler());
            configure.setDtd(this.dtd);
            configure.setPredefinedTagLibraries(this.getHandlersFromRegistry(file, proj));
            return configure;
        }
        return null;
    }

    private CompositeTagLibrary getHandlersFromRegistry(IFile file, Project proj) {
        IContentType contentType = Platform.getContentTypeManager().getContentType(HTMLSOURCE_CONTENT_TYPE_ID);
        CompositeTagRegistryFactory.TagRegistryIdentifier id = new CompositeTagRegistryFactory.TagRegistryIdentifier(this.project, contentType);
        ITagRegistry registry = CompositeTagRegistryFactory.getInstance().getRegistry(id);
        if (registry != null) {
            return new CompositeTagLibrary(new TagLibrary[]{new FaceletAdaptingLibrary(registry.getAllTagLibraries(), proj)});
        }
        return new CompositeTagLibrary(new TagLibrary[0]);
    }

    private IAppClassLoaderProvider.IClassLoader getClassLoader(IProject iProject) {
        IAppClassLoaderProvider appService;
        Project proj = (Project)iProject.getAdapter(Project.class);
        if (proj != null && (appService = (IAppClassLoaderProvider)proj.getAppService(IAppClassLoaderProvider.class)) != null) {
            return appService.getAppClassLoader();
        }
        return null;
    }

    private IWebRootResolver getResolver(IProject iProject) {
        Project proj = (Project)iProject.getAdapter(Project.class);
        if (proj != null) {
            return (IWebRootResolver)proj.getAppService(IWebRootResolver.class);
        }
        return null;
    }

    private URL getRootDir(IWebRootResolver rootResolver) {
        IResource resourceForPath = rootResolver.getResourceForPath("/");
        if (resourceForPath != null && (resourceForPath.getType() == 2 || resourceForPath.getType() == 4) && resourceForPath.isAccessible()) {
            URI locationURI = resourceForPath.getLocationURI();
            try {
                return locationURI.toURL();
            }
            catch (MalformedURLException e) {
                Activator.log(e);
            }
        }
        return null;
    }

    private URL getFileURL(IFile file) {
        URI locationURI = file.getLocationURI();
        try {
            return locationURI.toURL();
        }
        catch (MalformedURLException e) {
            Activator.log(e);
            return null;
        }
    }
}

