/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.facelets;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;
import oracle.eclipse.tools.webtier.jsf.facelets.dthandlers.DTCompositionHandler;
import oracle.eclipse.tools.webtier.jsf.facelets.dthandlers.DTIncludeHandler;
import org.apache.myfaces.view.facelets.tag.TagLibrary;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagAttribute;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;

public class FaceletAdaptingLibrary
implements TagLibrary {
    private final Map<String, Namespace> nsMap;
    private static final Set<String> SUPPORTED_HTML_TAGS;

    static {
        HashSet<String> supportedHtmlTags = new HashSet<String>();
        supportedHtmlTags.add("a");
        supportedHtmlTags.add("body");
        supportedHtmlTags.add("link");
        supportedHtmlTags.add("img");
        supportedHtmlTags.add("table");
        supportedHtmlTags.add("td");
        supportedHtmlTags.add("th");
        supportedHtmlTags.add("tr");
        supportedHtmlTags.add("input");
        supportedHtmlTags.add("head");
        supportedHtmlTags.add("title");
        SUPPORTED_HTML_TAGS = Collections.unmodifiableSet(supportedHtmlTags);
    }

    public FaceletAdaptingLibrary(Collection<? extends Namespace> adaptingNs, Project project) {
        this.nsMap = new HashMap<String, Namespace>(adaptingNs.size());
        for (Namespace namespace : adaptingNs) {
            this.nsMap.put(namespace.getNSUri(), namespace);
        }
    }

    public boolean containsTagHandler(String ns, String localName) {
        Namespace namespace = this.nsMap.get(ns);
        if (namespace != null) {
            return namespace.getViewElement(localName) != null;
        }
        return "http://www.w3.org/1999/xhtml".equals(ns) && SUPPORTED_HTML_TAGS.contains(localName);
    }

    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        Namespace namespace = this.nsMap.get(ns);
        OepeDTTagHandler handler = null;
        if (namespace != null) {
            ITagElement viewElement = namespace.getViewElement(localName);
            if ("http://java.sun.com/jsf/facelets".equals(ns)) {
                handler = this.maybeCreateDtHandler(ns, localName, viewElement, tag);
            }
            if (handler == null) {
                handler = new OepeDTTagHandler(viewElement, tag);
            }
        }
        if ("http://www.w3.org/1999/xhtml".equals(ns) && SUPPORTED_HTML_TAGS.contains(localName)) {
            handler = new OepeDTTagHandler(null, tag);
        }
        return handler;
    }

    private TagHandler maybeCreateDtHandler(String ns, String localName, ITagElement viewElement, TagConfig tag) {
        OepeDTTagHandler tagHandler = null;
        if ("http://java.sun.com/jsf/facelets".equals(ns)) {
            if ("include".equals(localName)) {
                tagHandler = new DTIncludeHandler(viewElement, tag);
            } else if ("composition".equals(localName)) {
                tagHandler = new DTCompositionHandler(viewElement, tag);
            }
        } else if ("http://xmlns.oracle.com/adf/faces/rich".equals(ns) && "pageTemplateDef".equals(localName)) {
            tagHandler = new DTCompositionHandler(viewElement, tag);
        }
        return tagHandler;
    }

    public boolean containsFunction(String ns, String name) {
        return false;
    }

    public Method createFunction(String ns, String name) {
        return null;
    }

    public boolean containsNamespace(String ns) {
        return this.nsMap.containsKey(ns);
    }

    public static class OepeDTTagHandler
    extends TagHandler {
        private ITagElement viewElement;

        public OepeDTTagHandler(ITagElement viewElement, TagConfig tag) {
            super(tag);
            this.viewElement = viewElement;
        }

        public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
            this.validate(ctx, parent);
            if (this.nextHandler != null) {
                this.nextHandler.apply(ctx, parent);
            }
        }

        protected void validate(FaceletContext ctx, UIComponent parent) {
            if (this.viewElement != null) {
                for (Map.Entry entry : this.viewElement.getAttributes().entrySet()) {
                    ITagAttribute attribute = (ITagAttribute)entry.getValue();
                    boolean required = attribute.isRequired();
                    if (!required || this.tag.getAttributes().get(attribute.getName()) != null) continue;
                    DesignTimeContext.getCurrentInstance().reportMissingRequiredAttribute(this.tag, attribute.getName());
                }
            }
        }
    }
}

