/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.document;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceReference;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.document.AbstractDocumentService;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.util.INavigationCaseProvider;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationCaseArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifact;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class NavigationCaseProvider
extends AbstractDocumentService
implements INavigationCaseProvider {
    public NavigationCaseProvider(IDocument document) {
        super(document);
    }

    public Collection<? extends NavigationCaseArtifact> getFromNavigationCases() {
        return this.getNavigationCases(true);
    }

    public Collection<? extends NavigationCaseArtifact> getToNavigationCases() {
        return this.getNavigationCases(false);
    }

    private Collection<? extends NavigationCaseArtifact> getNavigationCases(boolean from) {
        IDependencyModel model;
        ResourceArtifact documentArtifact;
        IFile file;
        if (this.getDocument() != null && (file = this.getDocument().getFile()) != null && file.isAccessible() && (documentArtifact = (model = DependencyModelManager.getInstance().getModel()).ensureResourceArtifact((IResource)file)) != null) {
            HashSet<? extends NavigationCaseArtifact> navigationCases = new HashSet<NavigationCaseArtifact>();
            String type = from ? "navigation-rule" : "navigation-case";
            Set typedArtifacts = model.queryArtifactsByTypes(Collections.singleton(type), file.getProject());
            for (IArtifact typedArtifact : typedArtifacts) {
                for (IArtifactReference reference : typedArtifact.getReferences()) {
                    if (!reference.refersTo((IArtifact)documentArtifact)) continue;
                    if (from) {
                        navigationCases.addAll(((NavigationRuleArtifact)typedArtifact).getNavigationCases());
                        continue;
                    }
                    navigationCases.add((NavigationCaseArtifact)typedArtifact);
                }
            }
            return navigationCases;
        }
        return new HashSet(0);
    }

    public IArtifact getToArtifact(IArtifact navigationCase) {
        if (navigationCase instanceof NavigationCaseArtifact) {
            Set references = navigationCase.getReferences();
            for (IArtifactReference reference : references) {
                IArtifact targetArtifact;
                if (!(reference instanceof ResourceReference) || (targetArtifact = reference.getTargetArtifact()) == null) continue;
                return targetArtifact;
            }
        }
        return null;
    }

    public IResource getToArtifactResource(IArtifact navigationCase, IArtifact toArtifact) {
        IResource[] resources;
        if (navigationCase instanceof NavigationCaseArtifact && toArtifact instanceof ResourceArtifact && (resources = ((ResourceArtifact)toArtifact).getAffectedResources()).length == 1) {
            return resources[0];
        }
        return null;
    }
}

