/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.discovery.AbstractTagDiscoveryParticipant;
import oracle.eclipse.tools.application.common.services.tagsupport.ITypedSymbol;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceFactory;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ContentTypeCollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.jsf.Activator;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.TagIncludeError;
import oracle.eclipse.tools.webtier.jsf.facelets.FaceletCompileUtil;
import oracle.eclipse.tools.webtier.jsf.tagsupport.IFaceletTagSymbolFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.jsf.context.IDocumentContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.JSFVersion;

public class FaceletDiscoveryParticipant
extends AbstractTagDiscoveryParticipant
implements IDiscoveryParticipant {
    private static Map<String, List<IFaceletTagSymbolFactory>> SYMBOL_FACTORIES;
    private static final String CTYPE_FACELET = "jsf.facelet";
    private static final String CTYPE_FACELET_COMPOSITE = "jsf.facelet.composite";
    static final Set<String> CONTENT_TYPES;

    static {
        HashMap<String, List<IFaceletTagSymbolFactory>> map = new HashMap<String, List<IFaceletTagSymbolFactory>>();
        for (IFaceletTagSymbolFactory factory : Activator.getDefault().getFaceletSymbolFactories()) {
            FaceletDiscoveryParticipant.addFactories(map, factory);
        }
        SYMBOL_FACTORIES = Collections.unmodifiableMap(map);
        CONTENT_TYPES = new LinkedHashSet<String>(1, 1.0f);
        CONTENT_TYPES.add(CTYPE_FACELET);
        CONTENT_TYPES.add(CTYPE_FACELET_COMPOSITE);
    }

    private static void addFactories(Map<String, List<IFaceletTagSymbolFactory>> map, IFaceletTagSymbolFactory faceletSymbolFactory) {
        List<String> uris = faceletSymbolFactory.getSupportedUris();
        for (String uri : uris) {
            List<IFaceletTagSymbolFactory> list = map.get(uri);
            if (list == null) {
                list = new ArrayList<IFaceletTagSymbolFactory>(1);
                map.put(uri, list);
            }
            list.add(faceletSymbolFactory);
        }
    }

    protected ICollectionFilter createCollectionFilter() {
        return new FaceletContentTypeCollectionFilter();
    }

    protected AbstractTagDiscoveryParticipant.ResourceData createResourceData(IResourceDiscoveryContext ctx) {
        return new FaceletResourceData(ctx);
    }

    protected boolean isDeferredEvaluationEL(String expression) {
        return false;
    }

    public void discover(IResourceDiscoveryContext context, IProgressMonitor monitor) {
        IResource resource = context.getResource();
        if (FaceletCompileUtil.isInValidCompileState()) {
            return;
        }
        if (resource != null && resource.getType() == 1 && this.match(context)) {
            if (!FaceletCompileUtil.isProjectValidCompileState(resource.getProject())) {
                return;
            }
            this.beginResource(context, monitor);
            try {
                IFile file = (IFile)resource;
                DesignTimeContext dtContext = FaceletCompileUtil.ensureContext(file);
                if (dtContext != null) {
                    DesignTimeContextData data = dtContext.getData();
                    Map allTagRanges = data.getTagRanges();
                    for (Map.Entry tagRanges : allTagRanges.entrySet()) {
                        DesignTimeContextData.TagId tagId = (DesignTimeContextData.TagId)tagRanges.getKey();
                        String uri = tagId.getUri();
                        String tagName = tagId.getName();
                        Set varDeclaringAttrsNames = AbstractTagDiscoveryParticipant.SymbolContribAggregatorData.getVarDeclaringTagAttributes((IFile)file, (String)uri, (String)tagName);
                        for (DesignTimeContextData.TagRange tagRange : (List)tagRanges.getValue()) {
                            for (DesignTimeContextData.AttributeRange attribute : tagRange.getAttributes()) {
                                String attrName = attribute.getName();
                                if (varDeclaringAttrsNames.contains(attrName)) {
                                    this.processSymbolContrib(uri, tagName, attrName, tagRange, attribute);
                                }
                                this.processELRanges(attribute);
                            }
                        }
                    }
                    this.handleErrors(dtContext);
                } else {
                    Activator.log(new Exception("Couldn't get a dtContext for discovery: " + resource));
                }
            }
            finally {
                this.endResource(context, monitor);
            }
        }
    }

    private void handleErrors(DesignTimeContext dtContext) {
        for (TagIncludeError tagIncludeError : dtContext.getData().getTagIncludeErrors()) {
            System.err.println(tagIncludeError.getLocalizedMessage());
        }
        for (TagIncludeError tagError : dtContext.getData().getTagIncludeErrors()) {
            System.err.println(tagError.getLocalizedMessage());
        }
    }

    private void processELRanges(DesignTimeContextData.AttributeRange attribute) {
        for (DesignTimeContextData.ELRange elrange : attribute.getELRanges()) {
            String elText = elrange.getELText();
            int length = elrange.getEndOffset() - elrange.getStartOffset();
            if (length < 0) continue;
            Range range = new Range((long)elrange.getStartOffset(), (long)length);
            this.reportELVarReference(elText, range);
        }
    }

    protected List<ValueReference> findValueReferences(ValueReferenceFactory vrFactory, DocumentVariableQuery query, Range range, String elExpression) {
        return vrFactory.createValueReference2(elExpression, (VariableQuery)query, range, false);
    }

    protected void processSymbolContrib(String uri, String elementName, String attributeName, DesignTimeContextData.TagRange range, DesignTimeContextData.AttributeRange attribute) {
        String symbolName;
        AbstractTagDiscoveryParticipant.SymbolContribAggregator aggregator = AbstractTagDiscoveryParticipant.SymbolContribAggregator.create((AbstractTagDiscoveryParticipant.SymbolContribAggregatorData)new FaceletSymbolContribAggregatorData(this.resourceData.getFile(), uri, elementName, attributeName, range, attribute, SYMBOL_FACTORIES, this.resourceData.getDocument()));
        if (aggregator != null && (symbolName = aggregator.getAttributeValue(attributeName)) != null && !"".equals(symbolName.trim())) {
            this.processSymbolContrib(uri, aggregator, symbolName);
        }
    }

    public void discoverFromExistingModel(IResourceDiscoveryContext context, IVisitableDOMModel model, IProgressMonitor monitor) {
        this.discover(context, monitor);
    }

    public Set<IResource> getDependentResources(IProject project, Set<IResource> changedResources, IProgressMonitor monitor) {
        return Collections.emptySet();
    }

    private class FaceletContentTypeCollectionFilter
    extends ContentTypeCollectionFilter {
        public FaceletContentTypeCollectionFilter() {
            super(CONTENT_TYPES);
        }

        public boolean match(IResource resource) {
            return super.match(resource) && JSFVersion.guessAtLeast((JSFVersion)JSFVersion.V2_0, (IProject)resource.getProject());
        }
    }

    private class FaceletResourceData
    extends AbstractTagDiscoveryParticipant.ResourceData {
        public FaceletResourceData(IResourceDiscoveryContext ctx) {
            super((AbstractTagDiscoveryParticipant)FaceletDiscoveryParticipant.this, ctx);
        }

        protected ITaglibContextResolver createTaglibResolver(IDocumentContext context) {
            return null;
        }

        public IDocumentContext getDocumentContext(IResourceDiscoveryContext resourceContext) {
            return null;
        }
    }

    public static class FaceletSymbolContribAggregatorData
    extends AbstractTagDiscoveryParticipant.SymbolContribAggregatorData {
        private final DesignTimeContextData.TagRange tagRange;
        private final Map<String, List<IFaceletTagSymbolFactory>> faceletSymbolFactories;
        private final DesignTimeContextData.AttributeRange attribute;
        private final IDocument doc;

        public FaceletSymbolContribAggregatorData(IFile file, String uri, String elementName, String attributeName, DesignTimeContextData.TagRange tagRange, DesignTimeContextData.AttributeRange attribute, Map<String, List<IFaceletTagSymbolFactory>> faceletSymbolFactories, IDocument doc) {
            super(file, uri, elementName, attributeName);
            this.tagRange = tagRange;
            this.faceletSymbolFactories = faceletSymbolFactories;
            this.attribute = attribute;
            this.doc = doc;
        }

        public String getAttributeValue(String attributeName) {
            DesignTimeContextData.AttributeRange attrRange = this.tagRange.getAttribute(attributeName);
            if (attrRange != null) {
                return attrRange.getAttr().getValue();
            }
            return null;
        }

        public ResourceLocation getElementLocation() {
            Range range = new Range((long)this.tagRange.getStartOffset(), (long)(this.tagRange.getEndOffset() - this.tagRange.getStartOffset()));
            return new ResourceLocation((IResource)this.getFile(), range);
        }

        public ResourceLocation getElementLocationInBaseSource() {
            return this.getElementLocation();
        }

        public ResourceLocation getLocation(ISymbol symbol) {
            Object adapter;
            IAdaptable domNode;
            if (symbol instanceof ITypedSymbol && (domNode = ((ITypedSymbol)symbol).getDOMNode()) != null && (adapter = domNode.getAdapter(DesignTimeContextData.AttributeRange.class)) != null) {
                DesignTimeContextData.AttributeRange attributeRange = (DesignTimeContextData.AttributeRange)adapter;
                DesignTimeContextData.TagRange tag = attributeRange.getParent();
                if (tag == null) {
                    return null;
                }
                int startOffset = tag.getStartOffset();
                int endOffset = tag.getEndOffset();
                Range range = new Range((long)startOffset, (long)(endOffset - startOffset));
                return new ResourceLocation((IResource)this.getFile(), range);
            }
            return null;
        }

        public ResourceLocation getLocationInBaseSourceFile(ISymbol symbol) {
            return this.getLocation(symbol);
        }

        public ISymbol createSymbol(String symbolName) {
            List<IFaceletTagSymbolFactory> list = this.faceletSymbolFactories.get(this.getUri());
            if (list != null && !list.isEmpty()) {
                for (IFaceletTagSymbolFactory factory : list) {
                    ISymbol symbol = factory.create(symbolName, 1, this.tagRange, this.attribute, this.doc);
                    if (symbol == null) continue;
                    return symbol;
                }
            }
            return null;
        }

        public boolean hasFactory() {
            return this.faceletSymbolFactories.containsKey(this.getUri());
        }
    }
}

