/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection;

import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.application.common.services.el.ELUtil;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.DelegatingPropertySymbol;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.PropertySymbolDelegate;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.SymbolDelegate;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.symbol.ISymbol;

public class StringElValueExpressionToMapEntryJavaFieldConverter
extends Converter {
    private final IFilePositionContext _context;

    public StringElValueExpressionToMapEntryJavaFieldConverter(IFilePositionContext context) {
        super(String.class, JDTDataType.MapEntryJavaField.class);
        this._context = context;
    }

    public Object convert(Object fromObject) {
        if (!(fromObject instanceof String)) {
            return null;
        }
        ValueReferenceELParser parser = new ValueReferenceELParser();
        ELExpression expression = parser.getELExpression(((String)fromObject).trim());
        if (expression != null) {
            ValueReferenceELParser elParser = new ValueReferenceELParser();
            List expressions = elParser.getExpressions(expression.getElText());
            if (expressions.size() == 0) {
                return null;
            }
            if (expressions.size() > 1) {
                LoggingService.logDebug((Plugin)Activator.getDefault(), (String)"Found more than one expression");
            }
            ValueReferenceELParser.ValueReferenceELExpr expr = (ValueReferenceELParser.ValueReferenceELExpr)expressions.get(0);
            String variableName = expr.getModelObjectName();
            List fields = expr.getPropertyObjectNames();
            return this.resolveToMapEntryJavaField(variableName, fields);
        }
        return null;
    }

    public JDTDataType.MapEntryJavaField resolveToMapEntryJavaField(String variableName, List<String> fields) {
        DataType.Field field;
        SymbolDelegate delegate;
        ISymbol symbol;
        if (fields.size() == 0) {
            return null;
        }
        if (fields.size() > 1) {
            LoggingService.logDebug((Plugin)Activator.getDefault(), (String)"Found more than one field");
        }
        if ((symbol = ELUtil.getSymbol((IModelContext)this._context, (String)variableName, fields)) instanceof DelegatingPropertySymbol && (delegate = ((DelegatingPropertySymbol)symbol).getDelegate()) instanceof PropertySymbolDelegate && (field = ((PropertySymbolDelegate)delegate).getField()) instanceof JDTDataType.MapEntryJavaField) {
            return (JDTDataType.MapEntryJavaField)field;
        }
        return null;
    }

    public static class NameMatcherForResourceBundleVar
    extends VariableQuery.NameMatcher {
        private final Collection<ResolutionTime> _rt;

        public NameMatcherForResourceBundleVar(String name, Collection<ResolutionTime> rt) {
            super(name);
            this._rt = rt;
        }

        public boolean matches(Variable variable) {
            return super.matches(variable) && variable.getType() instanceof JavaResourceBundleDataType && this._rt.contains(variable.getResolutionType());
        }
    }
}

