/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection;

import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentResourceCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.IStructuredModelCollectionVisitor;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.IResourceCollectionContext;
import oracle.eclipse.tools.webtier.jsf.config.JSFConfigFileContentTypeFilter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class JSFConfigurationArtifactCollector
implements IStructuredModelCollectionVisitor {
    public void beginResource(IStructuredDocumentResourceCollectionContext ctx, IProgressMonitor monitor) {
    }

    public final Set<IResource> getDependentResources(Set<IResource> changedResources, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return Collections.emptySet();
        }
        for (IResource resource : changedResources) {
            IVirtualFile v;
            IVirtualFolder rootFolder;
            if (monitor != null && monitor.isCanceled()) break;
            if (!JSFConfigFileContentTypeFilter.getInstance().match(resource)) continue;
            IProject prj = resource.getProject();
            IVirtualComponent vc = ComponentCore.createComponent((IProject)prj);
            if (vc == null || (rootFolder = vc.getRootFolder()) == null || (v = rootFolder.getFile("WEB-INF/web.xml")) == null) break;
            IFile webXmlFile = v.getUnderlyingFile();
            return Collections.singleton(webXmlFile);
        }
        return Collections.emptySet();
    }

    public boolean match(IResourceCollectionContext context) {
        return false;
    }

    public void endResource(IStructuredDocumentResourceCollectionContext ctx, IProgressMonitor monitor) {
    }

    public String getID() {
        return "JSF";
    }

    public void startCollecting(IStructuredDocumentCollectionContext context, IProgressMonitor monitor) {
    }

    public IStatus stopCollecting(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public boolean visit(IDOMNode node) {
        return false;
    }

    public boolean visit(IDOMAttr attribute) {
        return false;
    }

    public boolean visit(IDOMDocument document) {
        return false;
    }

    public boolean visit(IDOMElement element) {
        return false;
    }
}

