/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.collection.AbstractArtifactCollector;
import oracle.eclipse.tools.application.common.services.collection.AbstractTagCollector;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentResourceCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.application.common.services.collection.TagCollector;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ArtifactException;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jsp.Activator;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContextFactory;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.jsp.core.taglib.ITagDirRecord;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class FaceletTagCollector
extends AbstractArtifactCollector {
    private static final String ID = "FACELET";
    private static final String CTYPE_FACELETSOURCE = "jsf.facelet";
    private static final String CTYPE_FACELETCOMPOSITE = "jsf.facelet.composite";
    public static final Set<String> FACELET_CONTENT_TYPES;
    private IPath wkspaceRelativePath = null;
    private FaceletVisitor visitor = null;
    private boolean isCollectable = false;
    private IResource currentResource = null;

    static {
        LinkedHashSet<String> types = new LinkedHashSet<String>(3, 1.0f);
        types.add(CTYPE_FACELETSOURCE);
        types.add(CTYPE_FACELETCOMPOSITE);
        FACELET_CONTENT_TYPES = Collections.unmodifiableSet(types);
    }

    public FaceletTagCollector() {
        this(ID, FACELET_CONTENT_TYPES);
    }

    protected FaceletTagCollector(String collectorID, Set<String> contentTypes) {
        super(collectorID, FACELET_CONTENT_TYPES);
    }

    public void startCollecting(IStructuredDocumentCollectionContext context, IProgressMonitor monitor) {
        super.startCollecting(context, monitor);
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        IProject prj = context.getProject();
        if (prj != null && prj.isAccessible()) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)prj);
            if (component != null) {
                IVirtualFolder container = component.getRootFolder();
                this.wkspaceRelativePath = container.getWorkspaceRelativePath().makeAbsolute();
            } else {
                throw new AssertionError((Object)"Calling startCollecting on a project with no web root");
            }
        }
    }

    public void beginResource(IStructuredDocumentResourceCollectionContext resourceContext, IProgressMonitor monitor) {
        super.beginResource(resourceContext, monitor);
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.currentResource = resourceContext.getResource();
        this.isCollectable = this.currentResource.getType() == 1 && this.wkspaceRelativePath != null && this.currentResource.isAccessible() && this.wkspaceRelativePath.isPrefixOf(this.currentResource.getFullPath().makeAbsolute()) && this.getFilter().match((IResourceContext)resourceContext);
    }

    public boolean visit(IDOMNode node) {
        return this.visitor.visit(node);
    }

    public boolean visit(IDOMAttr attribute) {
        return this.visitor.visit(attribute);
    }

    public boolean visit(IDOMElement element) {
        return this.visitor.visit(element);
    }

    public boolean visit(IDOMDocument domDocument) {
        if (this.isCollectable) {
            IStructuredDocument structuredDocument = domDocument.getStructuredDocument();
            Map<String, ITagDirRecord> tagDirMap = this.getTagDirRecordMap(structuredDocument, this.currentResource.getFullPath());
            IDocument document = (IDocument)this.currentResource.getAdapter(IDocument.class);
            INamespaceContextFactory nsContextFactory = (INamespaceContextFactory)document.getAdapter(INamespaceContextFactory.class);
            assert (nsContextFactory != null);
            INamespaceContext namespaceContext = nsContextFactory.getNamespaceContext((IFile)this.currentResource);
            IXMLMetadataContext mdContext = (IXMLMetadataContext)document.getAdapter(IXMLMetadataContext.class);
            assert (mdContext != null);
            this.visitor = new FaceletVisitor(this.structuredContext, this.getID(), tagDirMap, namespaceContext, mdContext, this.currentResource);
        }
        return this.isCollectable && this.visitor.visit(domDocument);
    }

    private Map<String, ITagDirRecord> getTagDirRecordMap(IStructuredDocument document, IPath fullPath) {
        HashMap map = new HashMap();
        if (map.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(map);
    }

    public static class FaceletTagContextResolver
    extends TagCollector.DefaultTagContextUriResolver {
        public IPath resolve(IFile referringResource, IDOMElement owningElement, IDOMNode referringNode, String originalUri) {
            return super.resolve(referringResource, owningElement, referringNode, originalUri);
        }
    }

    private static class FaceletVisitor
    implements IStructuredXMLModelVisitor {
        private final INamespaceContext _namespaceContext;
        private final IFile _file;
        private final TagCollector _tagCollector;
        private final FaceletTagContextResolver _resolver;
        private final StructuredDocumentResourceLocationFactory _locationFactory;
        private final String _collectorId;

        public FaceletVisitor(IStructuredDocumentCollectionContext collectionContext, String collectorId, Map<String, ITagDirRecord> tagDirRecords, INamespaceContext namespaceContext, IXMLMetadataContext mdContext, IResource resource) {
            this._namespaceContext = namespaceContext;
            this._file = (IFile)resource;
            this._resolver = new FaceletTagContextResolver();
            this._locationFactory = new StructuredDocumentResourceLocationFactory(this._file);
            this._collectorId = collectorId;
            this._tagCollector = this.createTagCollector(this._namespaceContext, mdContext, collectionContext, (AbstractTagCollector.AbstractTagContextUriResolver)this._resolver, this._locationFactory, this._file, this._collectorId);
        }

        protected TagCollector createTagCollector(INamespaceContext namespaceContext, IXMLMetadataContext mdContext, IStructuredDocumentCollectionContext collectionContext, AbstractTagCollector.AbstractTagContextUriResolver contextUriResolver, StructuredDocumentResourceLocationFactory locationFactory, IFile baseFile, String collectorID) {
            return new TagCollector(namespaceContext, mdContext, collectionContext, contextUriResolver, locationFactory, baseFile, collectorID);
        }

        public boolean visit(IDOMNode node) {
            return false;
        }

        public boolean visit(IDOMAttr attribute) {
            return false;
        }

        public boolean visit(IDOMElement element) {
            try {
                this._tagCollector.collectArtifacts(element, this._file, null);
            }
            catch (ArtifactException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)((Object)e));
            }
            return true;
        }

        public boolean visit(IDOMDocument document) {
            return true;
        }
    }
}

