/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.AbstractSimpleCollectionParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.CollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ContentTypeCollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.IResourceCollectionContext;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.webtier.javawebapp.Activator;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.CompositeFaceletTagCollector;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.FaceletTagCollector;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.internal.FaceletTagCollectorRegistry;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContext;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelets.FaceletCompileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class FaceletTagCollectionParticipant
extends AbstractSimpleCollectionParticipant
implements ICollectionParticipant {
    private static ICollectionFilter sFILTER = new ContentTypeCollectionFilter(FaceletTagCollector.FACELET_CONTENT_TYPES);
    private CompositeFaceletTagCollector tagCollector = new CompositeFaceletTagCollector(FaceletTagCollectorRegistry.INSTANCE.getExtensions());

    public void collect(IResourceCollectionContext resourceContext, IProgressMonitor monitor) {
        if (FaceletCompileUtil.isInValidCompileState()) {
            return;
        }
        IResource resource = resourceContext.getResource();
        if (!FaceletCompileUtil.isProjectValidCompileState(resource.getProject())) {
            return;
        }
        if (!this.isInteresting(resource)) {
            return;
        }
        FacesConfigArtifact artifact = FacesConfigArtifact.FACTORY.getInstance(resource.getProject());
        if (artifact != null) {
            for (String id : this.tagCollector.getCollectorIDs()) {
                this.getContext().resetCollection((IArtifact)artifact, id, resource);
            }
        }
        for (String id : this.tagCollector.getCollectorIDs()) {
            resourceContext.resetCollection(id);
        }
        Set queryArtifactsByTypes = DependencyModelManager.getInstance().getModel().queryArtifactsByTypes(Collections.singleton("navigation-rule"), resource.getProject());
        for (IArtifact a : queryArtifactsByTypes) {
            if (!resource.equals((Object)a.getLocation().getResource())) continue;
            this.getContext().removeArtifact(a);
        }
        IFile collectFile = (IFile)resource;
        DesignTimeContext context = FaceletCompileUtil.ensureContext(collectFile);
        if (context == null) {
            Activator.log((Throwable)new Exception("Context returned null for " + collectFile));
            return;
        }
        this.tagCollector.resetForResource(collectFile);
        DesignTimeContextData data = context.getData();
        Map allTagRanges = data.getTagRanges();
        for (Map.Entry tagRanges : allTagRanges.entrySet()) {
            for (DesignTimeContextData.TagRange tagRange : (List)tagRanges.getValue()) {
                for (DesignTimeContextData.AttributeRange attribute : tagRange.getAttributes()) {
                    this.tagCollector.collect(this.getContext(), collectFile, tagRange.getTagIdentifier().getUri(), tagRange.getTagIdentifier().getName(), attribute, tagRange);
                }
            }
        }
    }

    private boolean isInteresting(IResource resource) {
        if (!sFILTER.match(resource)) {
            return false;
        }
        return resource.getType() == 1;
    }

    public void startCollecting(CollectionContext context, IProgressMonitor monitor) {
        super.startCollecting(context, monitor);
    }

    public IStatus stopCollecting(IProgressMonitor monitor) {
        return super.stopCollecting(monitor);
    }
}

