/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.MethodReferenceFactory;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceFactory;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.CollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.javawebapp.resource.WebRootUtil;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ConverterArtifactRef;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationCaseArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationCaseArtifactRef;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifactRef;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ValidatorArtifactRef;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.AbstractFaceletTagCollector;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.ArtifactBasedActionNavCaseMatcher;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.ConverterArtifactLocator;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.NavigationCaseArtifactLocator;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.NavigationRuleArtifactLocator;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.ValidatorArtifactLocator;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.ELModelObjectSubExpression;
import oracle.eclipse.tools.webtier.jsf.variable.ExpressionUtil;
import oracle.eclipse.tools.webtier.jsp.variables.JDTCodeVarAnalyzer;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.metadata.TleiAccess;
import oracle.eclipse.tools.xml.model.metadata.tlei.DependencyType;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypes;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class CoreFaceletTagCollector
extends AbstractFaceletTagCollector {
    private static final String JSF_RESOURCES_FOLDER = "resources";
    static final String ID = "CoreFaceletTagCollector";
    private static final String NO_NAME = "<no-name-specified>";
    private static final Set<String> supportedExtensions = new LinkedHashSet<String>(Arrays.asList("xhtml", "jsf", "faces"));
    private static final List<SubTypes> ALL_INTERESTING_TYPES;
    private static final Set<String> supportedUris;

    static {
        ArrayList<SubTypes> types = new ArrayList<SubTypes>();
        types.add(SubTypes.URI_SUBTYPE);
        types.add(SubTypes.IMAGE_URI_SUBTYPE);
        types.add(SubTypes.XML_URI_SUBTYPE);
        types.add(SubTypes.JSF_ACTION_SUBTYPE);
        types.add(SubTypes.JSF_CONVERTER_ID_SUBTYPE);
        types.add(SubTypes.JSF_VALIDATOR_ID_SUBTYPE);
        types.add(SubTypes.JSF_RESOURCE_PATH);
        types.trimToSize();
        ALL_INTERESTING_TYPES = Collections.unmodifiableList(types);
        HashSet<String> uris = new HashSet<String>();
        uris.add("http://java.sun.com/jsf/html");
        uris.add("http://java.sun.com/jsf/core");
        uris.add("http://java.sun.com/jsf/facelets");
        uris.add("http://www.w3.org/1999/xhtml");
        supportedUris = Collections.unmodifiableSet(uris);
    }

    protected CoreFaceletTagCollector(String id) {
        super(id);
    }

    public CoreFaceletTagCollector() {
        super(ID);
    }

    @Override
    public void resetForResource(IFile collectFile) {
    }

    @Override
    public void collect(CollectionContext context, IFile file, String uri, String name, DesignTimeContextData.AttributeRange attr, DesignTimeContextData.TagRange attrOwner) {
        SubTypes subType;
        ResourceArtifact fileArtifact = context.ensureResourceArtifact((IResource)file);
        IXMLMetadataContext mdContext = this.getMdContext(file);
        EStructuralFeature feature = ExtendedEcoreUtil.INSTANCE.getFeature(uri, name, attr.getName());
        if (fileArtifact != null && mdContext != null && feature != null && ALL_INTERESTING_TYPES.contains(subType = TleiAccess.INSTANCE.getSubtype(mdContext, feature))) {
            switch (subType) {
                case URI_SUBTYPE: 
                case IMAGE_URI_SUBTYPE: 
                case XML_URI_SUBTYPE: {
                    this.handleUriSubtype(context, mdContext, feature, attr, fileArtifact, file);
                    break;
                }
                case JSF_ACTION_SUBTYPE: {
                    this.collectAction(context, attr.getAttr().getValue(), file, fileArtifact, attr);
                    break;
                }
                case JSF_VALIDATOR_ID_SUBTYPE: {
                    this.collectValidator(context, attr.getAttr().getValue(), file, fileArtifact, attr);
                    break;
                }
                case JSF_CONVERTER_ID_SUBTYPE: {
                    this.collectConverter(context, attr.getAttr().getValue(), file, fileArtifact, attr);
                    break;
                }
                case JSF_RESOURCE_PATH: {
                    this.collectResourcePath(context, mdContext, file, fileArtifact, attr, attrOwner);
                    break;
                }
            }
        }
    }

    private void collectResourcePath(CollectionContext context, IXMLMetadataContext mdContext, IFile file, ResourceArtifact fileArtifact, DesignTimeContextData.AttributeRange attr, DesignTimeContextData.TagRange attrOwner) {
        IFolder resourceRoot = this.getResourceRoot(file.getProject());
        if (resourceRoot == null) {
            return;
        }
        if (!attr.getELRanges().isEmpty()) {
            return;
        }
        String resourceName = attr.getAttr().getValue();
        if (resourceName != null && !resourceName.trim().isEmpty()) {
            IFile referrantFile;
            resourceName = resourceName.trim();
            String uri = attrOwner.getTagIdentifier().getUri();
            String tagName = attrOwner.getTagIdentifier().getName();
            String libraryName = null;
            for (DesignTimeContextData.AttributeRange attrRange : attrOwner.getAttributes()) {
                SubTypes subType;
                EStructuralFeature feature = ExtendedEcoreUtil.INSTANCE.getFeature(uri, tagName, attrRange.getName());
                if (feature == null || !SubTypes.JSF_RESOURCE_LIBRARY_NAME.equals((Object)(subType = TleiAccess.INSTANCE.getSubtype(mdContext, feature)))) continue;
                if (!attrRange.getELRanges().isEmpty()) {
                    return;
                }
                libraryName = attrRange.getAttr().getValue();
                if (libraryName == null) break;
                libraryName = libraryName.trim();
                break;
            }
            IFolder resourceContainer = resourceRoot;
            if (libraryName != null) {
                IFolder folder = resourceRoot.getFolder((IPath)new Path(libraryName));
                if (folder.isAccessible()) {
                    resourceContainer = folder;
                } else {
                    return;
                }
            }
            if ((referrantFile = resourceContainer.getFile((IPath)new Path(resourceName))).isAccessible()) {
                ResourceLocation location = this.createLocation(file, attr);
                context.addReferencedResource((IArtifact)fileArtifact, (IResource)referrantFile, true, location, (byte)0, this.getID());
            }
        }
    }

    private IFolder getResourceRoot(IProject project) {
        IResource resourceForPath;
        IWebRootResolver webRootResolver = this.getWebRootResolver(project);
        if (webRootResolver != null && (resourceForPath = webRootResolver.getResourceForPath(JSF_RESOURCES_FOLDER)).getType() == 2) {
            return (IFolder)resourceForPath;
        }
        return null;
    }

    private IWebRootResolver getWebRootResolver(IProject iProj) {
        Project adapter = (Project)iProj.getAdapter(Project.class);
        if (adapter != null) {
            return (IWebRootResolver)adapter.getAppService(IWebRootResolver.class);
        }
        return null;
    }

    protected IXMLMetadataContext getMdContext(IFile file) {
        Object adapter = file.getAdapter(IDocument.class);
        if (adapter instanceof IDocument) {
            return (IXMLMetadataContext)((IDocument)adapter).getAdapter(IXMLMetadataContext.class);
        }
        return null;
    }

    protected void handleUriSubtype(CollectionContext context, IXMLMetadataContext mdContext, EStructuralFeature feature, DesignTimeContextData.AttributeRange attr, ResourceArtifact artifact, IFile referringResource) {
        String value = attr.getAttr().getValue();
        if (DependencyType.FILE_REFERENCE == TleiAccess.INSTANCE.getDependencyType(mdContext, feature)) {
            IFile realReferringResource = this.getRealReferringResource(referringResource.getProject(), attr);
            if (realReferringResource == null) {
                realReferringResource = referringResource;
            }
            this.collectReferencedResources(context, realReferringResource, attr, value, (IArtifact)(realReferringResource == referringResource ? artifact : context.ensureResourceArtifact((IResource)realReferringResource)));
        }
    }

    private void collectReferencedResources(CollectionContext context, IFile referringResource, DesignTimeContextData.AttributeRange referringNode, String originalUri, IArtifact referantArtifact) {
        ResourceLocation location = this.createLocation(referringResource, referringNode);
        if (location == null) {
            return;
        }
        IPath resolvedPath = this.resolve(referringResource, referringNode, originalUri);
        if (resolvedPath == null) {
            this.resolvePathFromEL(context, referringResource, referringNode, originalUri, referantArtifact, location);
        } else {
            IFile referencedFile = ResourcesPlugin.getWorkspace().getRoot().getFile(resolvedPath);
            context.addReferencedResource(referantArtifact, (IResource)referencedFile, true, location, (byte)0, this.getID());
        }
    }

    protected void collectAction(CollectionContext context, String action, IFile file, ResourceArtifact fileArtifact, DesignTimeContextData.AttributeRange actionAttr) {
        block6: {
            Set<String> outcomes;
            ArtifactBasedActionNavCaseMatcher actionNavCaseMatcher;
            ResourceLocation location;
            block4: {
                String suffix;
                int lastIndexOf;
                String fromOutcome;
                block5: {
                    location = this.createLocation(file, actionAttr);
                    fromOutcome = actionAttr.getELRanges().isEmpty() ? action : null;
                    String fromViewID = WebRootUtil.getRuntimePath((IFile)file);
                    actionNavCaseMatcher = new ArtifactBasedActionNavCaseMatcher(context, file, fromViewID);
                    outcomes = CoreFaceletTagCollector.getActionOutcomes(file, actionAttr);
                    if (!outcomes.isEmpty()) break block4;
                    NavigationCaseArtifact navCase = actionNavCaseMatcher.matchOutcome(action, fromOutcome, location);
                    if (navCase == null) break block5;
                    NavigationRuleArtifact navRule = (NavigationRuleArtifact)navCase.getOwner();
                    this.addNavRuleReference(context, file, fileArtifact, location, navRule, (IFile)navCase.getLocation().getResource());
                    this.addNavCaseReference(context, file, fileArtifact, location, navCase);
                    break block6;
                }
                IWebRootResolver webRootResolver = this.getWebRootResolver(file.getProject());
                if (webRootResolver == null || fromOutcome == null) break block6;
                String implicitNav = fromOutcome;
                int indexOfQuery = implicitNav.indexOf(63);
                if (indexOfQuery != -1) {
                    implicitNav = implicitNav.substring(indexOfQuery);
                }
                if ((lastIndexOf = implicitNav.lastIndexOf(46)) != -1 && supportedExtensions.contains(suffix = implicitNav.substring(lastIndexOf + 1))) {
                    IResource res = this.tryToResolve(implicitNav, webRootResolver);
                    this.addImplicitNavArtifacts(context, action, file, fileArtifact, location, fromOutcome, implicitNav, res);
                }
                for (String extension : supportedExtensions) {
                    IResource res = this.tryToResolve(String.valueOf(implicitNav) + "." + extension, webRootResolver);
                    this.addImplicitNavArtifacts(context, action, file, fileArtifact, location, fromOutcome, implicitNav, res);
                }
                break block6;
            }
            for (String outcome : outcomes) {
                NavigationCaseArtifact navCase = actionNavCaseMatcher.matchOutcome(action, outcome, location);
                if (navCase == null) continue;
                NavigationRuleArtifact navRule = (NavigationRuleArtifact)navCase.getOwner();
                this.addNavRuleReference(context, file, fileArtifact, location, navRule, (IFile)navCase.getLocation().getResource());
                this.addNavCaseReference(context, file, fileArtifact, location, navCase);
            }
        }
    }

    private void addImplicitNavArtifacts(CollectionContext context, String action, IFile file, ResourceArtifact fileArtifact, ResourceLocation location, String fromOutcome, String implicitNav, IResource res) {
        if (res != null && res.getType() == 1 && res.isAccessible()) {
            NavigationRuleArtifact impNavRule = this.getOrCreateImplicitNavigationRuleArtifact(context, implicitNav, location, file);
            NavigationCaseArtifact navigationCaseArtifact = new NavigationCaseArtifact(action, action, fromOutcome, impNavRule, location, location, ID);
            navigationCaseArtifact.setImplicit(true);
            this.addNavRuleReference(context, file, fileArtifact, location, impNavRule, (IFile)navigationCaseArtifact.getLocation().getResource());
            impNavRule.addNavigationCase(navigationCaseArtifact);
            context.addArtifact((IArtifact)navigationCaseArtifact, this.getID());
            this.addNavCaseReference(context, file, fileArtifact, location, navigationCaseArtifact);
            context.addReferencedResource((IArtifact)impNavRule, (IResource)file, false, location, (byte)0, this.getID());
            context.addReferencedResource((IArtifact)navigationCaseArtifact, res, false, location, (byte)0, this.getID());
        }
    }

    private void addNavRuleReference(CollectionContext context, IFile file, ResourceArtifact fileArtifact, ResourceLocation location, NavigationRuleArtifact navRule, IFile referringResource) {
        String navRuleName = this.getNavigationRuleName(navRule);
        NavigationRuleArtifactRef ruleRef = new NavigationRuleArtifactRef(navRuleName, new NavigationRuleArtifactLocator(file, referringResource), (IArtifact)fileArtifact, location, this.getID());
        context.addReferencedArtifact((IArtifact)fileArtifact, (IArtifactReference)ruleRef, true, (byte)0);
    }

    private void addNavCaseReference(CollectionContext context, IFile file, ResourceArtifact fileArtifact, ResourceLocation location, NavigationCaseArtifact navCase) {
        String navCaseName = this.getNavigationCaseName(navCase);
        NavigationCaseArtifactRef caseRef = new NavigationCaseArtifactRef(navCaseName, navCase.getOutcome() == null ? null : navCase.getOutcome(), new NavigationCaseArtifactLocator(navCaseName, file, (IFile)navCase.getLocation().getResource()), (IArtifact)fileArtifact, location, this.getID());
        context.addReferencedArtifact((IArtifact)fileArtifact, (IArtifactReference)caseRef, true, (byte)0);
    }

    private IResource tryToResolve(String implicitNav, IWebRootResolver webRootResolver) {
        if (webRootResolver != null) {
            return webRootResolver.getResourceForPath(implicitNav);
        }
        return null;
    }

    private void collectConverter(CollectionContext context, String converterID, IFile file, ResourceArtifact fileArtifact, DesignTimeContextData.AttributeRange converterAttr) {
        ResourceLocation location = this.createLocation(file, converterAttr);
        ValueReferenceELParser parser = new ValueReferenceELParser();
        ELExpression expression = parser.getELExpression(converterID);
        if (expression == null) {
            ConverterArtifactLocator locator = new ConverterArtifactLocator(converterID, file.getProject());
            ConverterArtifactRef ref = new ConverterArtifactRef(converterID, locator, (IArtifact)fileArtifact, location, this.getID());
            context.addReferencedArtifact((IArtifact)fileArtifact, (IArtifactReference)ref, true, (byte)0);
        }
    }

    private void collectValidator(CollectionContext context, String validatorId, IFile file, ResourceArtifact fileArtifact, DesignTimeContextData.AttributeRange validatorAttr) {
        ResourceLocation location = this.createLocation(file, validatorAttr);
        ValueReferenceELParser parser = new ValueReferenceELParser();
        ELExpression expression = parser.getELExpression(validatorId);
        if (expression == null) {
            ValidatorArtifactLocator locator = new ValidatorArtifactLocator(validatorId, file.getProject());
            ValidatorArtifactRef ref = new ValidatorArtifactRef(validatorId, locator, (IArtifact)fileArtifact, location, this.getID());
            context.addReferencedArtifact((IArtifact)fileArtifact, (IArtifactReference)ref, true, (byte)0);
        }
    }

    private String getNavigationRuleName(NavigationRuleArtifact navRule) {
        String navRuleName = navRule.getName() == null ? "*" : navRule.getName();
        return navRuleName == null || navRuleName.equals("") ? "*" : navRuleName;
    }

    private String getNavigationCaseName(NavigationCaseArtifact navCase) {
        String fromOutcome;
        String string = fromOutcome = navCase.getOutcome() == null ? null : navCase.getOutcome();
        if (fromOutcome == null) {
            return NO_NAME;
        }
        return fromOutcome;
    }

    public static Set<String> getActionOutcomes(IFile file, DesignTimeContextData.AttributeRange attrRange) {
        MethodReference methodRef;
        IDocument doc;
        if (attrRange.getELRanges().size() == 1 && (doc = (IDocument)file.getAdapter(IDocument.class)) != null && (methodRef = CoreFaceletTagCollector.getMethodReferenceFromAttribute(doc, attrRange)) != null && methodRef.getMethodReturnType() != null && !methodRef.getMethodReturnType().isUnknown()) {
            IMethod method = CoreFaceletTagCollector.getJavaMethod(file.getProject(), methodRef);
            JDTCodeVarAnalyzer cva = new JDTCodeVarAnalyzer();
            return cva.getReturnStringLiterals(method, file.getProject());
        }
        return Collections.emptySet();
    }

    private static MethodReference getMethodReferenceFromAttribute(IDocument doc, DesignTimeContextData.AttributeRange attrRange) {
        List modelSubExprs = ((DesignTimeContextData.ELRange)attrRange.getELRanges().get(0)).getModelSubExprs();
        if (modelSubExprs.size() == 1) {
            ELModelObjectSubExpression elModelObjectSubExpression = (ELModelObjectSubExpression)modelSubExprs.get(0);
            ValueReferenceELParser.ValueReferenceELExpr expr = ExpressionUtil.convert(elModelObjectSubExpression);
            DocumentVariableQuery varQuery = new DocumentVariableQuery(doc, -1);
            MethodReferenceFactory factory = new MethodReferenceFactory();
            return factory.maybeCreateMethodReference((VariableQuery)varQuery, new ValueReferenceFactory(), expr);
        }
        return null;
    }

    private static IMethod getJavaMethod(IProject project, MethodReference methodRef) {
        String[] methodParams = CoreFaceletTagCollector.getParamsAsStrings(methodRef);
        String methodName = methodRef.getMethodName();
        String clazz = CoreFaceletTagCollector.getClassType(methodRef);
        String[] methodParamSigs = new String[]{};
        if (methodParams != null) {
            methodParamSigs = new String[methodParams.length];
            int i = 0;
            while (i < methodParams.length) {
                methodParamSigs[i] = Signature.createTypeSignature((String)methodParams[i], (boolean)true);
                ++i;
            }
        }
        try {
            IJavaProject jProj = JavaCore.create((IProject)project);
            IType type = jProj.findType(clazz);
            return type.getMethod(methodName, methodParamSigs);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static String getClassType(MethodReference methodRef) {
        ValueReference valRef = methodRef.getValueReference();
        DataType type = valRef.getType(DataType.NullModelContext.getInstance());
        return type.getName();
    }

    private static String[] getParamsAsStrings(MethodReference methodRef) {
        List paramTypes = methodRef.getMethodParameterTypes();
        String[] params = new String[paramTypes.size()];
        int i = 0;
        while (i < paramTypes.size()) {
            DataType type = (DataType)paramTypes.get(i);
            params[i] = type.getName();
            ++i;
        }
        return params;
    }

    @Override
    public boolean supportsCollection(String uri, String name, String attrName) {
        return supportedUris.contains(uri);
    }

    private NavigationRuleArtifact getOrCreateImplicitNavigationRuleArtifact(CollectionContext context, String implicitNav, ResourceLocation location, IFile file) {
        NavigationRuleArtifact artifact = (NavigationRuleArtifact)implicitNavigationRuleArtifact.get(file);
        if (artifact == null) {
            FacesConfigArtifact owner = FacesConfigArtifact.FACTORY.getInstance(file.getProject());
            artifact = new NavigationRuleArtifact(WebRootUtil.getRuntimePath((IFile)file), location, location, owner, ID);
            artifact.setImplicitRule(true);
            context.addArtifact((IArtifact)artifact, ID);
            this.addNavRuleReference(context, file, context.ensureResourceArtifact((IResource)file), location, artifact, file);
            implicitNavigationRuleArtifact.put(file, artifact);
        }
        return artifact;
    }
}

