/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.CollectionContext;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationCaseArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifact;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class ArtifactBasedActionNavCaseMatcher {
    public static final String DEFAULT_VIEW_ID = "*";
    private final List<NavigationCaseArtifact> mNavCases = new ArrayList<NavigationCaseArtifact>();
    private final CollectionContext context;

    public ArtifactBasedActionNavCaseMatcher(CollectionContext context, IFile file, String viewId) {
        this.sortNavigationCases(file, viewId);
        this.context = context;
    }

    private void sortNavigationCases(IFile file, String viewId) {
        List<NavigationRuleArtifact> navigationRules = this.getNavigationRules(file);
        int countExactMatch = 0;
        for (NavigationRuleArtifact navRule : navigationRules) {
            String prefix;
            String fromViewId;
            String string = fromViewId = navRule.getName() == null ? "" : navRule.getName();
            if (viewId.equals(fromViewId)) {
                Collection<? extends NavigationCaseArtifact> navCases = navRule.getNavigationCases();
                this.mNavCases.addAll(countExactMatch, navCases);
                countExactMatch += navCases.size();
                continue;
            }
            if (fromViewId == null || fromViewId.length() == 0 || fromViewId.equals(DEFAULT_VIEW_ID)) {
                this.mNavCases.addAll(navRule.getNavigationCases());
                continue;
            }
            if (!fromViewId.endsWith(DEFAULT_VIEW_ID) || !viewId.startsWith(prefix = fromViewId.substring(0, fromViewId.length() - DEFAULT_VIEW_ID.length()))) continue;
            this.mNavCases.addAll(countExactMatch, navRule.getNavigationCases());
        }
    }

    private List<NavigationRuleArtifact> getNavigationRules(IFile file) {
        ArrayList<NavigationRuleArtifact> artifacts = new ArrayList<NavigationRuleArtifact>();
        Set queryArtifactsByTypes = DependencyModelManager.getInstance().getModel().queryArtifactsByTypes(Collections.singleton("navigation-rule"), file.getProject());
        for (IArtifact artifact : queryArtifactsByTypes) {
            IResource resource;
            boolean shouldInclude = true;
            ResourceLocation location = artifact.getLocation();
            if (location != null && (resource = location.getResource()) != null && resource.equals((Object)file)) {
                shouldInclude = false;
            }
            if (!shouldInclude) continue;
            artifacts.add((NavigationRuleArtifact)artifact);
        }
        return artifacts;
    }

    public Map<String, NavigationCaseArtifact> getPossibleOutcomes() {
        HashMap<String, NavigationCaseArtifact> map = new HashMap<String, NavigationCaseArtifact>();
        int count = this.mNavCases.size();
        int i = count - 1;
        while (i >= 0) {
            NavigationCaseArtifact navCase = this.mNavCases.get(i);
            if (navCase.getName() == null) {
                String fromOutcome;
                String string = fromOutcome = navCase.getOutcome() == null ? null : navCase.getOutcome();
                if (fromOutcome != null && fromOutcome.length() != 0) {
                    map.put(fromOutcome, navCase);
                }
            }
            --i;
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NavigationCaseArtifact matchAction(CollectionContext context, String action, boolean isMethodBinding, String outcome, ResourceLocation location) {
        NavigationCaseArtifact match = null;
        int matchSpecifity = 0;
        int i = 0;
        int n = this.mNavCases.size();
        while (i < n) {
            String fromOutcome;
            NavigationCaseArtifact navCase = this.mNavCases.get(i);
            String fromAction = navCase.getName() == null ? null : navCase.getName();
            String string = fromOutcome = navCase.getOutcome() == null ? null : navCase.getOutcome();
            if (fromAction != null) {
                if (isMethodBinding) {
                    if (action.equals(fromAction)) {
                        if (fromOutcome == null) {
                            if (matchSpecifity < 2) {
                                match = navCase;
                                matchSpecifity = 2;
                            }
                        } else if (outcome.equals(fromOutcome)) {
                            return navCase;
                        }
                    }
                } else if (outcome.equals(fromOutcome)) {
                    return navCase;
                }
            } else if (fromOutcome != null) {
                if (outcome.equals(fromOutcome)) {
                    if (!isMethodBinding) return navCase;
                    if (matchSpecifity < 2) {
                        match = navCase;
                        matchSpecifity = 2;
                    }
                }
            } else if (matchSpecifity == 0) {
                match = navCase;
                matchSpecifity = 1;
            }
            ++i;
        }
        return match;
    }

    public NavigationCaseArtifact matchOutcome(String action, String outcome, ResourceLocation location) {
        if (outcome == null || outcome.length() == 0) {
            return null;
        }
        return this.matchAction(this.context, action, false, outcome, location);
    }
}

