/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.application.common.services.collection.StringElValueExpressionToResourceBundleKeyPairConverter;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleKeyPair;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.CollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceReference;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.StringElValueExpressionToMapEntryJavaFieldConverter;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.ELModelObjectSubExpression;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.XMLTextRange;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractFaceletTagCollector {
    private String id;
    protected static final Map<IResource, NavigationRuleArtifact> implicitNavigationRuleArtifact = Collections.synchronizedMap(new HashMap());

    public AbstractFaceletTagCollector(String id) {
        this.id = id;
    }

    protected String getID() {
        return this.id;
    }

    public abstract void collect(CollectionContext var1, IFile var2, String var3, String var4, DesignTimeContextData.AttributeRange var5, DesignTimeContextData.TagRange var6);

    public boolean supportsCollection(String uri, String name, String attrName) {
        return false;
    }

    protected ResourceLocation createLocation(IFile referringResource, DesignTimeContextData.AttributeRange referringNode) {
        XMLTextRange valueRange = referringNode.getValueRange();
        if (valueRange != null) {
            return new ResourceLocation((IResource)referringResource, new Range((long)valueRange.getStartOffset(), (long)valueRange.getLength()));
        }
        return null;
    }

    protected IFile getRealReferringResource(IProject project, DesignTimeContextData.AttributeRange attrRange) {
        IWebRootResolver resolver;
        Project adapter;
        String path = attrRange.getAttr().getLocation().getPath();
        if (path != null && (adapter = (Project)project.getAdapter(Project.class)) != null && (resolver = (IWebRootResolver)adapter.getAppService(IWebRootResolver.class)) != null) {
            return (IFile)resolver.getResourceForPath(path);
        }
        return null;
    }

    protected IPath resolve(IFile referringResource, DesignTimeContextData.AttributeRange referringNode, String originalUri) {
        if (originalUri.startsWith("#{")) {
            return null;
        }
        if (originalUri.startsWith("/")) {
            IResource resourceForPath;
            IWebRootResolver resolver;
            IProject project = referringResource.getProject();
            Project adapter = (Project)project.getAdapter(Project.class);
            if (adapter != null && (resolver = (IWebRootResolver)adapter.getAppService(IWebRootResolver.class)) != null && (resourceForPath = resolver.getResourceForPath(originalUri)) != null) {
                return resourceForPath.getFullPath();
            }
        } else {
            IPath append = referringResource.getFullPath().removeLastSegments(1).append(originalUri);
            return append;
        }
        return null;
    }

    protected void resolvePathFromEL(CollectionContext context, IFile referringResource, DesignTimeContextData.AttributeRange referringNode, String originalUri, IArtifact referantArtifact, ResourceLocation location) {
        DesignTimeContextData.ELRange elRange;
        List elRanges = referringNode.getELRanges();
        if (elRanges.size() == 1 && (elRange = (DesignTimeContextData.ELRange)elRanges.get(0)).getModelSubExprs().size() == 1) {
            ELModelObjectSubExpression subExpr = (ELModelObjectSubExpression)elRange.getModelSubExprs().get(0);
            IDocument doc = (IDocument)referringResource.getAdapter(IDocument.class);
            DocumentVariableQuery bundleVarQuery = new DocumentVariableQuery(doc, (int)location.getRange().getOffset());
            FilePositionContext positionContext = new FilePositionContext((int)location.getRange().getOffset(), (IFile)location.getResource());
            StringElValueExpressionToResourceBundleKeyPairConverter converter = new StringElValueExpressionToResourceBundleKeyPairConverter((IFilePositionContext)positionContext, (VariableQuery)bundleVarQuery);
            ResourceBundleKeyPair keyPair = converter.resolveToResourceBundleKeyPair(subExpr.getModelObjectName().getName(), subExpr.getPropertyObjectNameStrings());
            if (keyPair != null && keyPair.getValue() != null) {
                IPath resolvedValue = this.resolve(referringResource, referringNode, keyPair.getValue().trim());
                IFile referencedFile = ResourcesPlugin.getWorkspace().getRoot().getFile(resolvedValue);
                ResourceReference reference = new ResourceReference(referantArtifact, location, (IResource)referencedFile, this.getID());
                context.addReferencedArtifact(referantArtifact, (IArtifactReference)reference, true, (byte)0);
            } else {
                IPath resolvedValue;
                String optionalValue;
                JDTDataType.MapEntryJavaField field = new StringElValueExpressionToMapEntryJavaFieldConverter((IFilePositionContext)positionContext).resolveToMapEntryJavaField(subExpr.getModelObjectName().getName(), subExpr.getPropertyObjectNameStrings());
                if (field != null && (optionalValue = field.getOptionalValue()) != null && (resolvedValue = this.resolve(referringResource, referringNode, optionalValue)) != null) {
                    IFile referencedFile = ResourcesPlugin.getWorkspace().getRoot().getFile(resolvedValue);
                    ResourceReference reference = new ResourceReference(referantArtifact, location, (IResource)referencedFile, this.getID());
                    context.addReferencedArtifact(referantArtifact, (IArtifactReference)reference, true, (byte)0);
                }
            }
        }
    }

    public abstract void resetForResource(IFile var1);
}

