/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.artifact;

import java.io.Serializable;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ValidatorArtifact;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;

public class ValidatorArtifactRef
extends AbstractArtifactReference
implements IAdaptable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String validatorId;
    private volatile transient int hashCode = 0;

    public ValidatorArtifactRef(String validatorId, IArtifactLocator targetLocator, IArtifact source, ResourceLocation location, String collectorID) {
        super(targetLocator, source);
        this.validatorId = validatorId;
        this.addLocation((IArtifactReferenceLocation)new ArtifactReferenceLocation(location, true, collectorID));
    }

    protected IArtifact createMissingArtifact() {
        IProject project = this.getOwner().getProject();
        FacesConfigArtifact facesConfigArtifact = FacesConfigArtifact.FACTORY.getInstance(project);
        Set<IFile> facesConfigFiles = facesConfigArtifact.getFacesConfigFiles();
        IFile facesConfigFile = null;
        if (facesConfigFiles != null && !facesConfigFiles.isEmpty()) {
            facesConfigFile = facesConfigFiles.iterator().next();
        } else {
            IVirtualFile virtualDefaultFacesConfigFile = ComponentCore.createFile((IProject)project, (IPath)new Path("WEB-INF/faces-config.xml"));
            facesConfigFile = virtualDefaultFacesConfigFile.getUnderlyingFile();
        }
        return new MissingValidatorArtifact(this.validatorId, new ResourceLocation((IResource)facesConfigFile, null), facesConfigArtifact);
    }

    public String getName() {
        return this.validatorId;
    }

    public String getType() {
        return "validator";
    }

    public boolean isMissing() {
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof ValidatorArtifactRef) {
            boolean validatorIdIsEqual;
            ValidatorArtifactRef otherRef = (ValidatorArtifactRef)object;
            if (this.validatorId != null) {
                validatorIdIsEqual = this.validatorId.equals(otherRef.validatorId);
            } else {
                boolean bl = validatorIdIsEqual = otherRef.validatorId == null;
            }
            return super.equals(object) && validatorIdIsEqual;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.validatorId);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    static class MissingValidatorArtifact
    extends ValidatorArtifact
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public MissingValidatorArtifact(String validatorId, ResourceLocation location, FacesConfigArtifact owner) {
            super(validatorId, location, location, owner, "MISSING");
        }

        @Override
        public boolean isMissing() {
            return true;
        }
    }
}

