/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.artifact;

import java.io.Serializable;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifact;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;

public class NavigationRuleArtifactRef
extends AbstractArtifactReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String fromViewId;
    private volatile transient int hashCode = 0;

    public NavigationRuleArtifactRef(String fromViewId, IArtifactLocator targetLocator, IArtifact source, ResourceLocation location, String collectorID) {
        super(targetLocator, source);
        this.fromViewId = fromViewId;
        this.addLocation((IArtifactReferenceLocation)new ArtifactReferenceLocation(location, true, collectorID));
    }

    protected IArtifact createMissingArtifact() {
        IProject project = this.getOwner().getProject();
        FacesConfigArtifact facesConfigArtifact = FacesConfigArtifact.FACTORY.getInstance(project);
        Set<IFile> facesConfigFiles = facesConfigArtifact.getFacesConfigFiles();
        IFile facesConfigFile = null;
        if (facesConfigFiles != null && !facesConfigFiles.isEmpty()) {
            facesConfigFile = facesConfigFiles.iterator().next();
        } else {
            IVirtualFile virtualDefaultFacesConfigFile = ComponentCore.createFile((IProject)project, (IPath)new Path("WEB-INF/faces-config.xml"));
            facesConfigFile = virtualDefaultFacesConfigFile.getUnderlyingFile();
        }
        return new MissingNavigationRuleArtifact(this.fromViewId, new ResourceLocation((IResource)facesConfigFile, null), facesConfigArtifact);
    }

    public String getName() {
        return this.fromViewId;
    }

    public String getType() {
        return "navigation-rule";
    }

    public boolean isMissing() {
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof NavigationRuleArtifactRef) {
            boolean fromViewIdIsEqual;
            NavigationRuleArtifactRef otherRef = (NavigationRuleArtifactRef)object;
            if (this.fromViewId != null) {
                fromViewIdIsEqual = this.fromViewId.equals(otherRef.fromViewId);
            } else {
                boolean bl = fromViewIdIsEqual = otherRef.fromViewId == null;
            }
            return super.equals(object) && fromViewIdIsEqual;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.fromViewId);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    static class MissingNavigationRuleArtifact
    extends NavigationRuleArtifact
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public MissingNavigationRuleArtifact(String fromViewID, ResourceLocation location, FacesConfigArtifact owner) {
            super(fromViewID, location, location, owner, "MISSING");
        }

        @Override
        public boolean isMissing() {
            return true;
        }
    }
}

