/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.artifact;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationCaseArtifact;

public class NavigationRuleArtifact
extends AbstractVirtualArtifact
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_ID = "navigation-rule";
    private final String fromViewID;
    private final FacesConfigArtifact owner;
    private final boolean hasNoFromViewIDElement;
    private final Map<String, NavigationCaseArtifact> cases = new HashMap<String, NavigationCaseArtifact>();
    private boolean isImplicitRule;

    public NavigationRuleArtifact(String fromViewID, ResourceLocation location, ResourceLocation boundedLocation, FacesConfigArtifact owner, String collectorID) {
        this(fromViewID, location, boundedLocation, owner, false, collectorID);
    }

    public NavigationRuleArtifact(String fromViewID, ResourceLocation location, ResourceLocation boundedLocation, FacesConfigArtifact owner, boolean hasNoFromViewIDElement, String collectorID) {
        super(location, boundedLocation, collectorID);
        if (fromViewID == null) {
            throw new NullPointerException();
        }
        this.fromViewID = fromViewID;
        this.owner = owner;
        this.hasNoFromViewIDElement = hasNoFromViewIDElement;
    }

    public final String getName() {
        return this.getFromViewId();
    }

    public String getFromViewId() {
        return this.fromViewID;
    }

    public IArtifact getOwner() {
        return this.owner;
    }

    public final String getType() {
        return TYPE_ID;
    }

    public boolean isMissing() {
        return false;
    }

    public NavigationCaseArtifact getNavigationCase(String caseName) {
        return this.cases.get(caseName);
    }

    public void addNavigationCase(NavigationCaseArtifact navigationCase) {
        this.cases.put(navigationCase.getName(), navigationCase);
    }

    public boolean hasNoFromViewIdElement() {
        return this.hasNoFromViewIDElement;
    }

    public Collection<? extends NavigationCaseArtifact> getNavigationCases() {
        return Collections.unmodifiableCollection(this.cases.values());
    }

    public boolean isImplicitRule() {
        return this.isImplicitRule;
    }

    public void setImplicitRule(boolean isImplicitRule) {
        this.isImplicitRule = isImplicitRule;
    }
}

