/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.artifact;

import java.io.Serializable;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationCaseArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifactRef;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;

public class NavigationCaseArtifactRef
extends AbstractArtifactReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String outcome;
    private final String action;
    private volatile transient int hashCode = 0;

    public NavigationCaseArtifactRef(String action, String outcome, IArtifactLocator targetLocator, IArtifact source, ResourceLocation location, String collectorID) {
        super(targetLocator, source);
        this.action = action;
        this.outcome = outcome;
        this.addLocation((IArtifactReferenceLocation)new ArtifactReferenceLocation(location, true, collectorID));
    }

    protected IArtifact createMissingArtifact() {
        IProject project = this.getOwner().getProject();
        FacesConfigArtifact facesConfigArtifact = FacesConfigArtifact.FACTORY.getInstance(project);
        Set<IFile> facesConfigFiles = facesConfigArtifact.getFacesConfigFiles();
        IFile facesConfigFile = null;
        if (facesConfigFiles != null && !facesConfigFiles.isEmpty()) {
            facesConfigFile = facesConfigFiles.iterator().next();
        } else {
            IVirtualFile virtualDefaultFacesConfigFile = ComponentCore.createFile((IProject)project, (IPath)new Path("WEB-INF/faces-config.xml"));
            if (virtualDefaultFacesConfigFile.exists()) {
                facesConfigFile = virtualDefaultFacesConfigFile.getUnderlyingFile();
            }
        }
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        NavigationRuleArtifact rule = (NavigationRuleArtifact)model.queryArtifactsByOwnerNameAndType((IArtifact)facesConfigArtifact, "*", "navigation-rule");
        if (rule == null) {
            rule = new NavigationRuleArtifactRef.MissingNavigationRuleArtifact(this.getOwner().getName(), new ResourceLocation((IResource)facesConfigFile, null), facesConfigArtifact);
        }
        return new MissingNavigationCaseArtifact(this.action, this.outcome, rule, new ResourceLocation((IResource)facesConfigFile, null));
    }

    public String getName() {
        return this.action == null ? this.outcome : this.action;
    }

    public String getType() {
        return "navigation-case";
    }

    public boolean isMissing() {
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof NavigationCaseArtifactRef) {
            boolean outcomeIsEqual;
            boolean actionIsEqual;
            NavigationCaseArtifactRef otherRef = (NavigationCaseArtifactRef)object;
            if (this.action != null) {
                actionIsEqual = this.action.equals(otherRef.action);
            } else {
                boolean bl = actionIsEqual = otherRef.action == null;
            }
            if (this.outcome != null) {
                outcomeIsEqual = this.outcome.equals(otherRef.outcome);
            } else {
                boolean bl = outcomeIsEqual = otherRef.outcome == null;
            }
            return super.equals(object) && actionIsEqual && outcomeIsEqual;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.action);
            hcu.hash((Object)this.outcome);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    protected static class Locator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String viewId;
        String action;
        String outcome;

        protected Locator() {
        }
    }

    private static class MissingNavigationCaseArtifact
    extends NavigationCaseArtifact
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public MissingNavigationCaseArtifact(String action, String outcome, NavigationRuleArtifact owningRule, ResourceLocation location) {
            super(action, action, outcome, owningRule, location, location, "MISSING");
        }

        @Override
        public boolean isMissing() {
            return true;
        }
    }
}

