/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.artifact;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.webtier.jsf.Activator;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigBeanArtifact;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;

public abstract class FacesConfigBeanArtifactReference
extends AbstractArtifactReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private volatile transient int hashCode = 0;

    public FacesConfigBeanArtifactReference(IArtifactLocator targetLocator, IArtifact source, String name, String propertyReference, ResourceLocation location, String collectorID) {
        super(targetLocator, source);
        this.addLocation((IArtifactReferenceLocation)new BeanArtifactReferenceLocation(location, propertyReference, true, collectorID));
        this.name = name;
    }

    protected IArtifact createMissingArtifact() {
        IProject project = this.getOwner().getProject();
        FacesConfigArtifact facesConfigArtifact = FacesConfigArtifact.FACTORY.getInstance(project);
        if (facesConfigArtifact == null) {
            Activator.log(new Exception("Could not get faces config artifact"));
            return new MissingBeanArtifact(this.name, new ResourceLocation((IResource)project, null), null);
        }
        Set<IFile> facesConfigFiles = facesConfigArtifact.getFacesConfigFiles();
        IFile facesConfigFile = null;
        if (facesConfigFiles != null && !facesConfigFiles.isEmpty()) {
            facesConfigFile = facesConfigFiles.iterator().next();
        } else {
            IVirtualFile virtualDefaultFacesConfigFile = ComponentCore.createFile((IProject)project, (IPath)new Path("WEB-INF/faces-config.xml"));
            if (virtualDefaultFacesConfigFile.exists()) {
                facesConfigFile = virtualDefaultFacesConfigFile.getUnderlyingFile();
            }
        }
        return new MissingBeanArtifact(this.name, new ResourceLocation((IResource)facesConfigFile, null), facesConfigArtifact);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.name);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    public boolean isMissing() {
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof FacesConfigBeanArtifactReference) {
            boolean nameIsEqual;
            FacesConfigBeanArtifactReference otherRef = (FacesConfigBeanArtifactReference)object;
            if (this.name != null) {
                nameIsEqual = this.name.equals(otherRef.name);
            } else {
                boolean bl = nameIsEqual = otherRef.name == null;
            }
            return super.equals(object) && nameIsEqual;
        }
        return false;
    }

    public Set<String> getReferencedProperties() {
        HashSet<String> propertyNames = new HashSet<String>();
        Set locs = this.getLocations();
        for (IArtifactReferenceLocation loc : locs) {
            if (!(loc instanceof BeanArtifactReferenceLocation)) continue;
            propertyNames.add(((BeanArtifactReferenceLocation)loc).getPropertyName());
        }
        return propertyNames;
    }

    public Set<BeanArtifactReferenceLocation> getLocationsForProperty(String propertyReference) {
        HashSet<BeanArtifactReferenceLocation> propertyLocations = new HashSet<BeanArtifactReferenceLocation>();
        Set locs = this.getLocations();
        for (IArtifactReferenceLocation loc : locs) {
            if (!(loc instanceof BeanArtifactReferenceLocation)) continue;
            String locPropertyName = ((BeanArtifactReferenceLocation)loc).getPropertyName();
            if ((propertyReference != null || locPropertyName != null) && (propertyReference == null || !propertyReference.equals(locPropertyName))) continue;
            propertyLocations.add((BeanArtifactReferenceLocation)loc);
        }
        return propertyLocations;
    }

    private static class BeanArtifactReferenceLocation
    extends ArtifactReferenceLocation {
        private static final long serialVersionUID = 1L;
        private final String propertyReference;

        public BeanArtifactReferenceLocation(ResourceLocation location, String propertyReference, boolean visible, String collectorID) {
            super(location, visible, collectorID);
            this.propertyReference = propertyReference;
        }

        public String getPropertyName() {
            return this.propertyReference;
        }

        public int hashCode() {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            return hcu.hash(super.hashCode()).hash((Object)this.propertyReference).getHashCode();
        }

        public boolean equals(Object anObject) {
            if (anObject instanceof BeanArtifactReferenceLocation) {
                return this.propertyReference == null ? ((BeanArtifactReferenceLocation)((Object)anObject)).propertyReference == null : this.propertyReference.equals(((BeanArtifactReferenceLocation)((Object)anObject)).propertyReference) && super.equals(anObject);
            }
            return false;
        }
    }

    private static class MissingBeanArtifact
    extends FacesConfigBeanArtifact
    implements Serializable {
        private static final long serialVersionUID = 1L;

        MissingBeanArtifact(String name, ResourceLocation location, FacesConfigArtifact owner) {
            super(name, location, location, (IArtifact)owner, "MISSING");
        }

        @Override
        public boolean isMissing() {
            return true;
        }
    }
}

