/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactCategory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ReferencedBeanArtifact;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class FacesConfigBeanArtifactLocator
implements IArtifactLocator,
Serializable {
    private static final String BEAN_CATEGORY_ID = "managed-bean";
    private static final long serialVersionUID = 1L;
    private final String variableName;
    private final IProject project;
    private IArtifactCategory managedBeanCat = null;
    private IArtifactCategory referencedBeanCat = null;
    private volatile transient int hashCode = 0;
    private String managedBeanCategoryId;

    public FacesConfigBeanArtifactLocator(IProject project, String variableName) {
        this.project = project;
        this.variableName = variableName;
        this.managedBeanCategoryId = BEAN_CATEGORY_ID;
    }

    public FacesConfigBeanArtifactLocator(IProject project, String beanCategoryId, String variableName) {
        this(project, variableName);
        this.managedBeanCategoryId = beanCategoryId == null ? BEAN_CATEGORY_ID : beanCategoryId;
    }

    public IArtifact locateArtifact() {
        for (IArtifact managedBean : this.getManagedBeanArtifacts()) {
            if (!(managedBean instanceof ManagedBeanArtifact) || !((ManagedBeanArtifact)managedBean).getName().equals(this.variableName)) continue;
            return managedBean;
        }
        for (IArtifact referencedBean : this.getReferencedBeanArtifacts()) {
            if (!(referencedBean instanceof ReferencedBeanArtifact) || !((ReferencedBeanArtifact)referencedBean).getName().equals(this.variableName)) continue;
            return referencedBean;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<IArtifact> getManagedBeanArtifacts() {
        ArtifactController controller = ArtifactControllerFactory.getController();
        FacesConfigBeanArtifactLocator facesConfigBeanArtifactLocator = this;
        synchronized (facesConfigBeanArtifactLocator) {
            if (this.managedBeanCat == null) {
                Set allCats = controller.getAllCategories(this.project);
                for (IArtifactCategory cat : allCats) {
                    if (!cat.getCategoryId().equals(this.managedBeanCategoryId)) continue;
                    this.managedBeanCat = cat;
                    break;
                }
            }
        }
        if (this.managedBeanCat != null) {
            return controller.getAllArtifactsInCategory(this.managedBeanCat, this.project);
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<IArtifact> getReferencedBeanArtifacts() {
        ArtifactController controller = ArtifactControllerFactory.getController();
        FacesConfigBeanArtifactLocator facesConfigBeanArtifactLocator = this;
        synchronized (facesConfigBeanArtifactLocator) {
            if (this.referencedBeanCat == null) {
                Set allCats = controller.getAllCategories(this.project);
                for (IArtifactCategory cat : allCats) {
                    if (!cat.getCategoryId().equals("referenced-bean")) continue;
                    this.referencedBeanCat = cat;
                    break;
                }
            }
        }
        if (this.referencedBeanCat != null) {
            return controller.getAllArtifactsInCategory(this.referencedBeanCat, this.project);
        }
        return Collections.emptySet();
    }

    public boolean equals(Object other) {
        if (other instanceof FacesConfigBeanArtifactLocator) {
            FacesConfigBeanArtifactLocator otherMBAL = (FacesConfigBeanArtifactLocator)other;
            if (otherMBAL.project == this.project) {
                return this.variableName == null ? otherMBAL.variableName == null : this.variableName.equals(otherMBAL.variableName);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash((Object)this.project);
            hcu.hash((Object)this.variableName);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.project);
        out.writeObject(this.variableName);
        out.writeObject(this.managedBeanCategoryId);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalProjectFromStream((Object)this, "project");
        su.readFinalFieldFromStream((Object)this, "variableName", String.class);
        su.readFinalFieldFromStream((Object)this, "managedBeanCategoryId", String.class);
        this.managedBeanCat = null;
        this.referencedBeanCat = null;
    }
}

