/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.artifact;

import java.io.Serializable;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ConverterArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigArtifact;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;

public class ConverterArtifactRef
extends AbstractArtifactReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String converterId;
    private volatile transient int hashCode = 0;

    public ConverterArtifactRef(String converterId, IArtifactLocator targetLocator, IArtifact source, ResourceLocation location, String collectorID) {
        super(targetLocator, source);
        this.converterId = converterId;
        this.addLocation((IArtifactReferenceLocation)new ArtifactReferenceLocation(location, true, collectorID));
    }

    protected IArtifact createMissingArtifact() {
        IProject project = this.getOwner().getProject();
        FacesConfigArtifact facesConfigArtifact = FacesConfigArtifact.FACTORY.getInstance(project);
        Set<IFile> facesConfigFiles = facesConfigArtifact.getFacesConfigFiles();
        IFile facesConfigFile = null;
        if (facesConfigFiles != null && !facesConfigFiles.isEmpty()) {
            facesConfigFile = facesConfigFiles.iterator().next();
        } else {
            IVirtualFile virtualDefaultFacesConfigFile = ComponentCore.createFile((IProject)project, (IPath)new Path("WEB-INF/faces-config.xml"));
            facesConfigFile = virtualDefaultFacesConfigFile.getUnderlyingFile();
        }
        return new MissingConverterArtifact(this.converterId, new ResourceLocation((IResource)facesConfigFile, null), facesConfigArtifact);
    }

    public String getName() {
        return this.converterId;
    }

    public String getType() {
        return "converter";
    }

    public boolean isMissing() {
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof ConverterArtifactRef) {
            boolean converterIdIsEqual;
            ConverterArtifactRef otherRef = (ConverterArtifactRef)object;
            if (this.converterId != null) {
                converterIdIsEqual = this.converterId.equals(otherRef.converterId);
            } else {
                boolean bl = converterIdIsEqual = otherRef.converterId == null;
            }
            return super.equals(object) && converterIdIsEqual;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.converterId);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    static class MissingConverterArtifact
    extends ConverterArtifact
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public MissingConverterArtifact(String converterId, ResourceLocation location, FacesConfigArtifact owner) {
            super(converterId, null, location, location, owner, "MISSING");
        }

        @Override
        public boolean isMissing() {
            return true;
        }
    }
}

