/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.config.annotation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentFamilyType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentTypeType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterForClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitIdType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererClassType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererTypeType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;

class AnnotatedFacesModelSearchRequestor
extends SearchRequestor {
    private final FacesConfigType facesConfig;

    AnnotatedFacesModelSearchRequestor(FacesConfigType facesConfig) {
        this.facesConfig = facesConfig;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        IType type;
        IAnnotation[] annotations;
        Object element;
        if (match.getAccuracy() == 0 && (element = match.getElement()) instanceof IType && (annotations = (type = (IType)element).getAnnotations()) != null) {
            int i = 0;
            int k = annotations.length;
            while (i < k) {
                String annotationType;
                String[][] resolvedAnnotationTypes;
                if (annotations[i].exists() && (resolvedAnnotationTypes = type.resolveType(annotationType = annotations[i].getElementName())) != null) {
                    String resolvedAnnotationClassName = new StringBuffer(resolvedAnnotationTypes[0][0]).append('.').append(resolvedAnnotationTypes[0][1]).toString();
                    if ("javax.faces.bean.ManagedBean".equals(resolvedAnnotationClassName)) {
                        this.addManagedBean(annotations[i], type);
                    } else if ("javax.faces.bean.ReferencedBean".equals(resolvedAnnotationClassName)) {
                        this.addReferencedBean(annotations[i], type);
                    } else if ("javax.faces.component.FacesComponent".equals(resolvedAnnotationClassName)) {
                        this.addComponent(annotations[i], type);
                    } else if ("javax.faces.convert.FacesConverter".equals(resolvedAnnotationClassName)) {
                        this.addConverter(annotations[i], type);
                    } else if ("javax.faces.render.FacesRenderer".equals(resolvedAnnotationClassName)) {
                        this.addRenderer(annotations[i], type);
                    } else if ("javax.faces.validator.FacesValidator".equals(resolvedAnnotationClassName)) {
                        this.addValidator(annotations[i], type);
                    }
                }
                ++i;
            }
        }
    }

    private void addReferencedBean(IAnnotation referencedBeanAnnotation, IType beanType) throws JavaModelException {
        IMemberValuePair[] pairs = referencedBeanAnnotation.getMemberValuePairs();
        String beanNameString = null;
        if (pairs != null) {
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("name".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    beanNameString = (String)pair.getValue();
                }
                ++n2;
            }
        }
        if (beanNameString == null && (beanNameString = beanType.getElementName()) != null && !beanNameString.isEmpty()) {
            StringBuffer casedName = new StringBuffer(String.valueOf(beanNameString.charAt(0)).toUpperCase());
            beanNameString = casedName.append(beanNameString.substring(1)).toString();
        }
        String beanClassName = beanType.getFullyQualifiedName();
        if (beanNameString != null && beanClassName != null) {
            ReferencedBeanType bean = FacesConfigFactory.eINSTANCE.createReferencedBeanType();
            ReferencedBeanNameType beanName = FacesConfigFactory.eINSTANCE.createReferencedBeanNameType();
            beanName.setTextContent(beanNameString);
            bean.setReferencedBeanName(beanName);
            ReferencedBeanClassType beanClass = FacesConfigFactory.eINSTANCE.createReferencedBeanClassType();
            beanClass.setTextContent(beanClassName);
            bean.setReferencedBeanClass(beanClass);
            this.facesConfig.getReferencedBean().add((Object)bean);
        }
    }

    private void addManagedBean(IAnnotation beanAnnotation, IType beanType) throws JavaModelException {
        IMemberValuePair[] scopePairs;
        IMemberValuePair[] pairs = beanAnnotation.getMemberValuePairs();
        String beanNameString = null;
        Boolean isBeanEager = Boolean.FALSE;
        if (pairs != null) {
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("name".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    beanNameString = (String)pair.getValue();
                } else if ("eager".equals(pair.getMemberName()) && pair.getValueKind() == 8) {
                    isBeanEager = (Boolean)pair.getValue();
                }
                ++n2;
            }
        }
        if ((beanNameString == null || beanNameString.isEmpty()) && (beanNameString = beanType.getElementName()) != null && !beanNameString.isEmpty()) {
            StringBuffer casedName = new StringBuffer(String.valueOf(beanNameString.charAt(0)).toUpperCase());
            beanNameString = casedName.append(beanNameString.substring(1)).toString();
        }
        String beanClassName = beanType.getFullyQualifiedName();
        String beanScopeString = "request";
        if (beanType.getAnnotation("javax.faces.bean.ApplicationScoped").exists()) {
            beanScopeString = "application";
        } else if (beanType.getAnnotation("javax.faces.bean.ViewScoped").exists()) {
            beanScopeString = "view";
        } else if (beanType.getAnnotation("javax.faces.bean.NoneScoped").exists()) {
            beanScopeString = "none";
        } else if (beanType.getAnnotation("javax.faces.bean.SessionScoped").exists()) {
            beanScopeString = "session";
        } else if (beanType.getAnnotation("javax.faces.bean.CustomScoped").exists() && (scopePairs = beanType.getAnnotation("javax.faces.bean.CustomScoped").getMemberValuePairs()) != null && scopePairs.length == 1 && scopePairs[0].getValueKind() == 9) {
            beanScopeString = (String)scopePairs[0].getValue();
        }
        if (beanNameString != null && beanClassName != null) {
            ManagedBeanType bean = FacesConfigFactory.eINSTANCE.createManagedBeanType();
            ManagedBeanNameType beanName = FacesConfigFactory.eINSTANCE.createManagedBeanNameType();
            beanName.setTextContent(beanNameString);
            bean.setManagedBeanName(beanName);
            ManagedBeanClassType beanClass = FacesConfigFactory.eINSTANCE.createManagedBeanClassType();
            beanClass.setTextContent(beanClassName);
            bean.setManagedBeanClass(beanClass);
            ManagedBeanScopeType beanScope = FacesConfigFactory.eINSTANCE.createManagedBeanScopeType();
            beanScope.setTextContent(beanScopeString);
            bean.setManagedBeanScope(beanScope);
            bean.setEager(isBeanEager.booleanValue());
            this.facesConfig.getManagedBean().add((Object)bean);
        }
    }

    private void addValidator(IAnnotation validatorAnnotation, IType validatorType) throws JavaModelException {
        String validatorClassName = validatorType.getFullyQualifiedName();
        IMemberValuePair[] pairs = validatorAnnotation.getMemberValuePairs();
        String validatorIDString = null;
        if (pairs != null) {
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("value".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    validatorIDString = (String)pair.getValue();
                }
                ++n2;
            }
        }
        if (validatorClassName != null && validatorIDString != null) {
            ValidatorType validator = FacesConfigFactory.eINSTANCE.createValidatorType();
            ValidatorClassType validatorClass = FacesConfigFactory.eINSTANCE.createValidatorClassType();
            validatorClass.setTextContent(validatorClassName);
            validator.setValidatorClass(validatorClass);
            ValidatorIdType validatorID = FacesConfigFactory.eINSTANCE.createValidatorIdType();
            validatorID.setTextContent(validatorIDString);
            validator.setValidatorId(validatorID);
            this.facesConfig.getValidator().add((Object)validator);
        }
    }

    private void addRenderer(IAnnotation rendererAnnotation, IType rendererType) throws JavaModelException {
        String rendererClassName = rendererType.getFullyQualifiedName();
        IMemberValuePair[] pairs = rendererAnnotation.getMemberValuePairs();
        String rendererTypeString = null;
        String componentFamilyString = null;
        String renderKitIDString = null;
        if (pairs != null) {
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("rendererType".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    rendererTypeString = (String)pair.getValue();
                } else if ("componentFamily".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    componentFamilyString = (String)pair.getValue();
                } else if ("renderKitId".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    renderKitIDString = (String)pair.getValue();
                }
                ++n2;
            }
        }
        if (rendererClassName != null && rendererTypeString != null && componentFamilyString != null) {
            EList renderKits;
            RendererType renderer = FacesConfigFactory.eINSTANCE.createRendererType();
            RendererClassType rendererClass = FacesConfigFactory.eINSTANCE.createRendererClassType();
            rendererClass.setTextContent(rendererClassName);
            renderer.setRendererClass(rendererClass);
            RendererTypeType rendererTypeType = FacesConfigFactory.eINSTANCE.createRendererTypeType();
            rendererTypeType.setTextContent(rendererTypeString);
            renderer.setRendererType(rendererTypeType);
            ComponentFamilyType componentFamily = FacesConfigFactory.eINSTANCE.createComponentFamilyType();
            componentFamily.setTextContent(componentFamilyString);
            renderer.setComponentFamily(componentFamily);
            if (renderKitIDString == null) {
                renderKitIDString = "HTML_BASIC";
            }
            if ((renderKits = this.facesConfig.getRenderKit()) != null) {
                RenderKitType renderKit = null;
                int i = 0;
                int k = renderKits.size();
                while (i < k) {
                    if (((RenderKitType)renderKits.get(i)).getRenderKitId() != null && renderKitIDString.equals(((RenderKitType)renderKits.get(i)).getRenderKitId().getTextContent())) {
                        renderKit = (RenderKitType)renderKits.get(i);
                    }
                    ++i;
                }
                if (renderKit == null) {
                    renderKit = FacesConfigFactory.eINSTANCE.createRenderKitType();
                    RenderKitIdType renderKitID = FacesConfigFactory.eINSTANCE.createRenderKitIdType();
                    renderKitID.setTextContent(renderKitIDString);
                    renderKit.setRenderKitId(renderKitID);
                    renderKits.add((Object)renderKit);
                }
                renderKit.getRenderer().add((Object)renderer);
            }
        }
    }

    private void addConverter(IAnnotation converterAnnotation, IType converterType) throws JavaModelException {
        String converterClassName = converterType.getFullyQualifiedName();
        IMemberValuePair[] pairs = converterAnnotation.getMemberValuePairs();
        String converterIDString = null;
        String converterForClassString = null;
        if (pairs != null) {
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("value".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    converterIDString = (String)pair.getValue();
                } else if ("forClass".equals(pair.getMemberName()) && pair.getValueKind() == 11) {
                    converterForClassString = (String)pair.getValue();
                }
                ++n2;
            }
        }
        if (converterClassName != null) {
            ConverterType converter = FacesConfigFactory.eINSTANCE.createConverterType();
            ConverterClassType converterClass = FacesConfigFactory.eINSTANCE.createConverterClassType();
            converterClass.setTextContent(converterClassName);
            converter.setConverterClass(converterClass);
            if (converterIDString != null) {
                ConverterIdType converterID = FacesConfigFactory.eINSTANCE.createConverterIdType();
                converterID.setTextContent(converterIDString);
                converter.setConverterId(converterID);
            }
            if (converterForClassString == null) {
                converterForClassString = "java.lang.Object";
            }
            ConverterForClassType converterForClass = FacesConfigFactory.eINSTANCE.createConverterForClassType();
            converterForClass.setTextContent(converterForClassString);
            converter.setConverterForClass(converterForClass);
            this.facesConfig.getConverter().add((Object)converter);
        }
    }

    private void addComponent(IAnnotation componentAnnotation, IType componentType) throws JavaModelException {
        String componentClassName = componentType.getFullyQualifiedName();
        IMemberValuePair[] pairs = componentAnnotation.getMemberValuePairs();
        String componentTypeString = null;
        if (pairs != null) {
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("value".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    componentTypeString = (String)pair.getValue();
                }
                ++n2;
            }
        }
        if (componentTypeString != null && componentClassName != null) {
            ComponentType component = FacesConfigFactory.eINSTANCE.createComponentType();
            ComponentClassType componentClass = FacesConfigFactory.eINSTANCE.createComponentClassType();
            componentClass.setTextContent(componentClassName);
            component.setComponentClass(componentClass);
            ComponentTypeType componentTypeType = FacesConfigFactory.eINSTANCE.createComponentTypeType();
            componentTypeType.setTextContent(componentTypeString);
            component.setComponentType(componentTypeType);
            this.facesConfig.getComponent().add((Object)component);
        }
    }
}

