/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.config.annotation;

import java.util.LinkedHashSet;
import oracle.eclipse.tools.webtier.jsf.config.annotation.AnnotatedFacesModelAppConfigProvider;
import oracle.eclipse.tools.webtier.jsf.config.annotation.FacesAnnotatedPackageFragmentRoot;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;
import org.eclipse.jst.jsf.core.jsfappconfig.AbstractJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class AnnotatedFacesModelLocator
extends AbstractJSFAppConfigLocater {
    private final IElementChangedListener listener = new ElementChangeListener();
    private IPath webInfLibPath = null;
    private IPath webInfClassesPath = null;

    public void startLocating() {
        IPath webContentPath;
        IContainer webContentFolder;
        IVirtualFolder webContent;
        IProject project = this.getJSFAppConfigManager().getProject();
        if (JSFAppConfigUtils.isValidJSFProject((IProject)project, (String)"2.0") && (webContent = new AbstractVirtualComponentQuery.DefaultVirtualComponentQuery().getWebContentFolder(project)) != null && (webContentFolder = webContent.getUnderlyingFolder()) != null && webContentFolder.exists() && (webContentPath = webContentFolder.getProjectRelativePath()) != null) {
            this.webInfLibPath = webContentPath.append("WEB-INF/lib");
            this.webInfClassesPath = webContentPath.append("WEB-INF/classes");
            this.addProvider();
            JavaCore.addElementChangedListener((IElementChangedListener)this.listener);
        }
    }

    private void addProvider() {
        LinkedHashSet<AnnotatedFacesModelAppConfigProvider> newConfigProviders = new LinkedHashSet<AnnotatedFacesModelAppConfigProvider>();
        newConfigProviders.add(new AnnotatedFacesModelAppConfigProvider());
        this.updateConfigProviders(newConfigProviders);
    }

    public void stopLocating() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.listener);
    }

    private class ElementChangeListener
    implements IElementChangedListener {
        private ElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (this.isRelevantChange(event.getDelta(), AnnotatedFacesModelLocator.this.getJSFAppConfigManager().getProject())) {
                AnnotatedFacesModelLocator.this.addProvider();
            }
        }

        private final boolean isRelevantChange(IJavaElementDelta delta, IProject project) {
            IJavaElementDelta[] childDeltas;
            int deltaFlags = delta.getFlags();
            if ((deltaFlags & 0x481C1) != 0) {
                IJavaElement changedElement = delta.getElement();
                switch (changedElement.getElementType()) {
                    case 5: {
                        if (changedElement instanceof ICompilationUnit) {
                            return true;
                        }
                        IType type = (IType)changedElement;
                        IPath classFilePath = type.getPath();
                        if (classFilePath != null && project.getFullPath().append(AnnotatedFacesModelLocator.this.webInfClassesPath).isPrefixOf(classFilePath)) {
                            return true;
                        }
                    }
                    case 3: {
                        IPath archivePath;
                        IPackageFragmentRoot root = (IPackageFragmentRoot)changedElement;
                        if (!root.isArchive() || root.isExternal() || (archivePath = root.getPath()) == null || !project.getFullPath().append(AnnotatedFacesModelLocator.this.webInfLibPath).isPrefixOf(archivePath)) break;
                        if ((deltaFlags & 0x80) != 0) {
                            return true;
                        }
                        FacesAnnotatedPackageFragmentRoot wrapper = new FacesAnnotatedPackageFragmentRoot(root);
                        return wrapper.canContainAnnotatedComponents();
                    }
                }
            }
            if ((childDeltas = delta.getAffectedChildren()) != null) {
                IJavaElementDelta[] iJavaElementDeltaArray = childDeltas;
                int n = childDeltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
                    if (this.isRelevantChange(childDelta, project)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

