/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.common.util.XmlParseException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.jsfappconfig.AbstractJSFAppConfigProvider;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterForClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JARFileJSFAppConfigProvider
extends AbstractJSFAppConfigProvider {
    public static final String JARFILE_URI_PREFIX = "jar:file:///";
    public static final String FACES_CONFIG_IN_JAR_SUFFIX = "!/META-INF/faces-config.xml";
    protected String filename = null;
    protected FacesConfigType facesConfig = null;
    protected boolean loadErrorLogged = false;
    private static final String CONVERTER = "converter";
    private static final String CONVERTER_CLASS = "converter-class";
    private static final String CONVERTER_ID = "converter-id";
    private static final String CONVERTER_FOR_CLASS = "converter-for-class";
    private static final String MANAGED_BEAN = "managed-bean";
    private static final String MANAGED_BEAN_CLASS = "managed-bean-class";
    private static final String MANAGED_BEAN_NAME = "managed-bean-name";
    private static final String MANAGED_BEAN_SCOPE = "managed-bean-scope";
    private static final String VALIDATOR = "validator";
    private static final String VALIDATOR_CLASS = "validator-class";
    private static final String VALIDATOR_ID = "validator-id";

    public JARFileJSFAppConfigProvider(String filename) {
        this.filename = filename;
    }

    public FacesConfigType getFacesConfigModel() {
        if (this.facesConfig == null && this.filename != null) {
            this.facesConfig = this.getFacesConfig();
            if (this.facesConfig != null) {
                this.jsfAppConfigLocater.getJSFAppConfigManager().addFacesConfigChangeAdapter(this.facesConfig);
            }
        }
        return this.facesConfig;
    }

    public void releaseFacesConfigModel() {
        this.jsfAppConfigLocater.getJSFAppConfigManager().removeFacesConfigChangeAdapter(this.facesConfig);
        this.facesConfig = null;
    }

    protected void logLoadError(Throwable ex) {
        if (!this.loadErrorLogged) {
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.jsf", (Throwable)ex, (String)NLS.bind((String)Messages.JARFileJSFAppConfigProvider_ErrorLoadingModel, (Object)(JARFILE_URI_PREFIX + this.filename + FACES_CONFIG_IN_JAR_SUFFIX)));
            this.loadErrorLogged = true;
        }
    }

    public boolean equals(Object otherObject) {
        boolean equals = false;
        if (otherObject instanceof JARFileJSFAppConfigProvider) {
            String otherFilename = ((JARFileJSFAppConfigProvider)((Object)otherObject)).filename;
            equals = this.filename != null ? this.filename.equals(otherFilename) : otherFilename == null;
        }
        return equals;
    }

    public int hashCode() {
        return this.filename != null ? this.filename.hashCode() : 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("JARFileJSFAppConfigProvider[");
        if (this.filename != null) {
            sb.append(this.filename);
        } else {
            sb.append("null");
        }
        sb.append("]");
        return sb.toString();
    }

    private FacesConfigType getFacesConfig() {
        FacesConfigType fc = null;
        JarFile jarFile = null;
        try {
            block35: {
                jarFile = new JarFile(this.filename, false);
                ZipEntry entry = jarFile.getEntry("META-INF/faces-config.xml");
                if (entry != null) {
                    fc = FacesConfigFactory.eINSTANCE.createFacesConfigType();
                    InputStream stream = jarFile.getInputStream(entry);
                    try {
                        try {
                            Element root;
                            Document doc = DomUtil.doc((InputStream)stream);
                            if (doc != null && (root = doc.getDocumentElement()) != null) {
                                NodeList nodes = root.getChildNodes();
                                int i = 0;
                                while (i < nodes.getLength()) {
                                    Node node = nodes.item(i);
                                    if (node.getNodeType() == 1) {
                                        Element element = (Element)node;
                                        String name = element.getLocalName();
                                        if (CONVERTER.equals(name)) {
                                            this.addConverter(fc, element);
                                        } else if (MANAGED_BEAN.equals(name)) {
                                            this.addManagedBean(fc, element);
                                        } else if (VALIDATOR.equals(name)) {
                                            this.addValidator(fc, element);
                                        }
                                    }
                                    ++i;
                                }
                            }
                        }
                        catch (XmlParseException xpe) {
                            this.logLoadError(xpe);
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Exception exception) {}
                            }
                            break block35;
                        }
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            FacesConfigType facesConfigType = fc;
            return facesConfigType;
        }
        catch (IOException ioe) {
            this.logLoadError(ioe);
            return null;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ioe) {
                    this.logLoadError(ioe);
                }
            }
        }
    }

    private void addConverter(FacesConfigType fc, Element element) {
        Element idElem;
        String classValue = null;
        String idValue = null;
        String forClassValue = null;
        Element classNameElem = DomUtil.element((Element)element, (String)CONVERTER_CLASS);
        if (classNameElem != null) {
            classValue = DomUtil.text((Node)classNameElem);
        }
        if ((idElem = DomUtil.element((Element)element, (String)CONVERTER_ID)) != null) {
            idValue = DomUtil.text((Node)idElem);
        } else {
            Element forClassElem = DomUtil.element((Element)element, (String)CONVERTER_FOR_CLASS);
            if (forClassElem != null) {
                forClassValue = DomUtil.text((Node)forClassElem);
            }
        }
        ConverterType converter = FacesConfigFactory.eINSTANCE.createConverterType();
        if (classValue != null && !(classValue = classValue.trim()).isEmpty()) {
            ConverterClassType converterClass = FacesConfigFactory.eINSTANCE.createConverterClassType();
            converterClass.setTextContent(classValue);
            converter.setConverterClass(converterClass);
        }
        if (idValue != null && !(idValue = idValue.trim()).isEmpty()) {
            ConverterIdType converterID = FacesConfigFactory.eINSTANCE.createConverterIdType();
            converterID.setTextContent(idValue);
            converter.setConverterId(converterID);
        }
        if (forClassValue != null && !(forClassValue = forClassValue.trim()).isEmpty()) {
            ConverterForClassType converterForClass = FacesConfigFactory.eINSTANCE.createConverterForClassType();
            converterForClass.setTextContent(forClassValue);
            converter.setConverterForClass(converterForClass);
        }
        fc.getConverter().add((Object)converter);
    }

    private void addManagedBean(FacesConfigType fc, Element element) {
        Element scopeElem;
        Element classElem;
        String nameValue = null;
        String classValue = null;
        String scopeValue = null;
        Element nameElem = DomUtil.element((Element)element, (String)MANAGED_BEAN_NAME);
        if (nameElem != null) {
            nameValue = DomUtil.text((Node)nameElem);
        }
        if ((classElem = DomUtil.element((Element)element, (String)MANAGED_BEAN_CLASS)) != null) {
            classValue = DomUtil.text((Node)classElem);
        }
        if ((scopeElem = DomUtil.element((Element)element, (String)MANAGED_BEAN_SCOPE)) != null) {
            scopeValue = DomUtil.text((Node)scopeElem);
        }
        ManagedBeanType bean = FacesConfigFactory.eINSTANCE.createManagedBeanType();
        if (nameValue != null && !(nameValue = nameValue.trim()).isEmpty()) {
            ManagedBeanNameType beanName = FacesConfigFactory.eINSTANCE.createManagedBeanNameType();
            beanName.setTextContent(nameValue);
            bean.setManagedBeanName(beanName);
        }
        if (classValue != null && !(classValue = classValue.trim()).isEmpty()) {
            ManagedBeanClassType klass = FacesConfigFactory.eINSTANCE.createManagedBeanClassType();
            klass.setTextContent(classValue);
            bean.setManagedBeanClass(klass);
        }
        if (scopeValue != null && !(scopeValue = scopeValue.trim()).isEmpty()) {
            ManagedBeanScopeType scope = FacesConfigFactory.eINSTANCE.createManagedBeanScopeType();
            scope.setTextContent(scopeValue);
            bean.setManagedBeanScope(scope);
        }
        fc.getManagedBean().add((Object)bean);
    }

    private void addValidator(FacesConfigType fc, Element element) {
        Element classElem;
        String idValue = null;
        String classValue = null;
        Element idElem = DomUtil.element((Element)element, (String)VALIDATOR_ID);
        if (idElem != null) {
            idValue = DomUtil.text((Node)idElem);
        }
        if ((classElem = DomUtil.element((Element)element, (String)VALIDATOR_CLASS)) != null) {
            classValue = DomUtil.text((Node)classElem);
        }
        ValidatorType validator = FacesConfigFactory.eINSTANCE.createValidatorType();
        if (idValue != null && !(idValue = idValue.trim()).isEmpty()) {
            ValidatorIdType validatorID = FacesConfigFactory.eINSTANCE.createValidatorIdType();
            validatorID.setTextContent(idValue);
            validator.setValidatorId(validatorID);
        }
        if (classValue != null && !(classValue = classValue.trim()).isEmpty()) {
            ValidatorClassType validatorClass = FacesConfigFactory.eINSTANCE.createValidatorClassType();
            validatorClass.setTextContent(classValue);
            validator.setValidatorClass(validatorClass);
        }
        fc.getValidator().add((Object)validator);
    }
}

