/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.appservices.IExpectedFacetService;
import oracle.eclipse.tools.application.common.services.appservices.TechExtensionVersionProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentContentProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.application.common.services.documentservices.IExternalVariableProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IImplicitVariableProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IValueBindableComponentProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IVersionProvider;
import oracle.eclipse.tools.application.common.services.documentservices.internal.IDocumentLocalizationContextWorkingCopy;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.techextservices.EnumVarGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.FieldsGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.IPreferredTagLibraryHandler;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ExternalVariable;
import oracle.eclipse.tools.application.common.services.variables.IFileVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.IFileVariablesCacheProvider;
import oracle.eclipse.tools.application.common.services.variables.IProjectVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.ImplicitVariable;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.model.internal.ITechnologyDiscoveryStore;
import oracle.eclipse.tools.common.services.document.AbstractDocumentService;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.HashingComparator;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IDocumentService;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.app.services.IAppService;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDescriptor;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.TechnologyDocumentServiceAdapterFactory;
import oracle.eclipse.tools.common.services.project.technology.TechnologyToFacetMap;
import oracle.eclipse.tools.common.services.refactoring.IArtifactRefactoringService;
import oracle.eclipse.tools.common.services.techextservices.IDocumentBinder;
import oracle.eclipse.tools.common.services.util.INavigationCaseProvider;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.webapp.Localizer;
import oracle.eclipse.tools.webtier.javawebapp.document.LocalizationSerializer;
import oracle.eclipse.tools.webtier.jsf.Activator;
import oracle.eclipse.tools.webtier.jsf.ValueBindableComponentProviderForJSF;
import oracle.eclipse.tools.webtier.jsf.document.FaceletBinder;
import oracle.eclipse.tools.webtier.jsf.document.NavigationCaseProvider;
import oracle.eclipse.tools.webtier.jsf.facelets.FaceletCompilerCache;
import oracle.eclipse.tools.webtier.jsf.facelets.IFaceletCompiler;
import oracle.eclipse.tools.webtier.jsf.jsp.document.DataTableGenerator;
import oracle.eclipse.tools.webtier.jsf.jsp.document.FacesJSPUtil;
import oracle.eclipse.tools.webtier.jsf.jsp.document.OutputTextFieldGenerator;
import oracle.eclipse.tools.webtier.jsf.jsp.document.PanelGridFieldsGenerator;
import oracle.eclipse.tools.webtier.jsf.locale.FacesLocalizer;
import oracle.eclipse.tools.webtier.jsf.locale.JsfAppLocalizer;
import oracle.eclipse.tools.webtier.jsf.locale.JsfDocumentLocalizationContext;
import oracle.eclipse.tools.webtier.jsf.refactoring.internal.ManagedBeanRenameValidator;
import oracle.eclipse.tools.webtier.jsf.variable.FacesBundleExternalVariable;
import oracle.eclipse.tools.webtier.jsf.variable.FacesExternalVariable;
import oracle.eclipse.tools.webtier.jsf.variable.JSFImplicitVariable;
import oracle.eclipse.tools.webtier.jsp.variables.DefaultImplicitImmediateVariableProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.designtime.symbols.DefaultBuiltInSymbolProvider;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JSFTechnologyExtension
extends AbstractTechnologyExtension
implements ITechnologyDiscoveryStore,
IPreferredTagLibraryHandler {
    public static final String ID = "jsf";
    private final TechnologyToFacetMap _techToFacetMap;
    private final IAppLocalizer _appLocalizer;
    private final Set<String> _supportedURIs;

    public JSFTechnologyExtension(Project project, ITechnologyDescriptor techDescriptor) {
        super(project, techDescriptor);
        this._techToFacetMap = new TechnologyToFacetMap(project.getEclipseProject(), this.getTechExtDescriptor().getDiscovererInstance().getTechnologyDiscoveryProvider());
        this._appLocalizer = new JsfAppLocalizer(this.getTechExtDescriptor().getTechnologyIdentifier(), (Localizer)new FacesLocalizer(project));
        this._supportedURIs = this.initializeUris();
    }

    private Set<String> initializeUris() {
        HashSet<String> uris = new HashSet<String>();
        uris.add("http://java.sun.com/jsf/core");
        uris.add("http://java.sun.com/jsf/html");
        return uris;
    }

    public <T extends IAppService> T getAppService(Class<T> serviceType) {
        if (serviceType == IExpectedFacetService.class) {
            return (T)new IExpectedFacetService(){

                public Set<IProjectFacetVersion> getExpectedFacetVersion() {
                    return JSFTechnologyExtension.this._techToFacetMap.getExpectedFacets(JSFTechnologyExtension.this.getTechExtDescriptor().getTechnologyIdentifier());
                }

                public boolean hasCorrectFacets() {
                    Set<IProjectFacetVersion> expectedFacets = this.getExpectedFacetVersion();
                    boolean hasFacets = true;
                    for (IProjectFacetVersion expectedFacet : expectedFacets) {
                        try {
                            hasFacets &= FacetedProjectFramework.hasProjectFacet((IProject)JSFTechnologyExtension.this.getProject().getEclipseProject(), (String)expectedFacet.getProjectFacet().getId(), (String)expectedFacet.getVersionString());
                        }
                        catch (CoreException e) {
                            LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
                            hasFacets = false;
                        }
                    }
                    return hasFacets;
                }
            };
        }
        if (serviceType == IAppLocalizer.class) {
            return (T)this._appLocalizer;
        }
        if (serviceType == ITechnologyDiscoveryStore.class) {
            return (T)((Object)this);
        }
        if (serviceType == IPreferredTagLibraryHandler.class) {
            return (T)((Object)this);
        }
        if (serviceType == oracle.eclipse.tools.application.common.services.appservices.IVersionProvider.class) {
            return (T)new TechExtensionVersionProvider((AbstractTechnologyExtension)this, this._supportedURIs);
        }
        if (serviceType == IArtifactRefactoringService.class) {
            return (T)new IArtifactRefactoringService(){

                public RefactoringStatus validateArtifactRename(IArtifact artifact, String newName) {
                    return new ManagedBeanRenameValidator().validateArtifactRename(artifact, newName);
                }
            };
        }
        if (serviceType == IFaceletCompiler.class) {
            FaceletCompilerCache faceletCompilerCache = Activator.getDefault().getFaceletCompilerCache();
            if (faceletCompilerCache != null) {
                try {
                    return (T)((IAppService)faceletCompilerCache.getInstance((IResource)this.getProject().getEclipseProject()));
                }
                catch (ObjectManager.ManagedObjectException e) {
                    Activator.log(e);
                }
            }
            return null;
        }
        return (T)super.getAppService(serviceType);
    }

    public IDocumentService getDocumentService(Class<? extends IDocumentService> serviceType, IDocument forDocument) {
        if (IExternalVariableProvider.class.equals(serviceType)) {
            return new ExternalVariableProviderForJSF(forDocument);
        }
        if (IImplicitVariableProvider.class.equals(serviceType)) {
            return new ImplicitVariableProviderForJSF(forDocument);
        }
        if (IDocumentBinder.class.equals(serviceType) && forDocument.getDocumentType().equals("jsf.FaceletDocument")) {
            return new FaceletBinder(forDocument);
        }
        if (IDocumentContentProvider.class.equals(serviceType)) {
            return new DocumentContentProviderForJSF(forDocument);
        }
        if (IValueBindableComponentProvider.class.equals(serviceType)) {
            return new ValueBindableComponentProviderForJSF(forDocument);
        }
        if (IFileVariablesCacheProvider.class.equals(serviceType) && forDocument.getDocumentType().equals("jsf.FaceletDocument")) {
            return new JSFFileVariablesCacheProvider(forDocument);
        }
        if (IVersionProvider.class.equals(serviceType)) {
            return new IVersionProvider(){

                public IDocument getDocument() {
                    return null;
                }

                public IVersion getVersion(String nsId) {
                    return JSFTechnologyExtension.this.getAppService(oracle.eclipse.tools.application.common.services.appservices.IVersionProvider.class).getVersion(nsId);
                }
            };
        }
        if (INavigationCaseProvider.class.equals(serviceType)) {
            return new NavigationCaseProvider(forDocument);
        }
        return super.getDocumentService(serviceType, forDocument);
    }

    protected TechnologyDocumentServiceAdapterFactory getServiceAdapterFactory() {
        return new TechnologyDocumentServiceAdapterFactory(){

            protected IDocumentService doCreateAdapter(Class<? extends IDocumentService> adapterType, IDocument document) {
                if (IDocumentLocalizationContext.class.equals(adapterType) || IDocumentLocalizationContextWorkingCopy.class.equals(adapterType)) {
                    return new JsfDocumentLocalizationContext(document, JSFTechnologyExtension.this.getTechExtDescriptor().getTechnologyIdentifier(), JSFTechnologyExtension.this.getAppService(IAppLocalizer.class));
                }
                return null;
            }

            public HashingComparator getHashingComparator(Class<? extends IDocumentService> adapterType) {
                return new HashingComparator(){

                    public boolean equals(Object obj, Object obj2) {
                        if (obj instanceof Class && obj2 instanceof Class && ((Class)obj).isAssignableFrom(IDocumentLocalizationContext.class) && ((Class)obj2).isAssignableFrom(IDocumentLocalizationContext.class)) {
                            return true;
                        }
                        return super.equals(obj, obj2);
                    }

                    public int hashCode(Class<?> adapterClass) {
                        if (adapterClass.isAssignableFrom(IDocumentLocalizationContext.class)) {
                            return IDocumentLocalizationContext.class.hashCode();
                        }
                        return super.hashCode(adapterClass);
                    }
                };
            }
        };
    }

    public void close() {
        super.close();
        this._appLocalizer.dispose();
    }

    public IStatus load(int saveNumber) {
        LocalizationSerializer ls = new LocalizationSerializer(this.getProject().getEclipseProject(), (ITechnologyExtension)this);
        return ls.load(saveNumber);
    }

    public IStatus store(int saveNumber, int prevSaveNumber) {
        LocalizationSerializer ls = new LocalizationSerializer(this.getProject().getEclipseProject(), (ITechnologyExtension)this);
        return ls.store(this.getCachedAdapters(IDocumentLocalizationContext.class), saveNumber, prevSaveNumber);
    }

    public IPreferredTagLibraryHandler.Preference handleTagLibrary(String uri) {
        if (uri.equals("http://java.sun.com/jsf/core") || uri.equals("http://java.sun.com/jsf/html")) {
            return IPreferredTagLibraryHandler.Preference.PREFERRED;
        }
        if (uri.equals("http://mojarra.dev.java.net/mojarra_ext")) {
            return IPreferredTagLibraryHandler.Preference.NOT_PREFERRED;
        }
        return IPreferredTagLibraryHandler.Preference.NOT_HANDLED;
    }

    private static class DocumentContentProviderForJSF
    extends AbstractDocumentService
    implements IDocumentContentProvider {
        public DocumentContentProviderForJSF(IDocument doc) {
            super(doc);
        }

        public int getPriority() {
            return 10;
        }

        public List<EnumVarGenerator> getEnumVarGenerators(ValueReference valRef) {
            ArrayList<EnumVarGenerator> results = new ArrayList<EnumVarGenerator>();
            if (FacesJSPUtil.isVisibleValueRef(valRef) && FacesJSPUtil.isFacesPage(this.getDocument())) {
                results.add(new DataTableGenerator(this.getDocument()));
            }
            return results;
        }

        public List<FieldsGenerator> getFieldGenerators(ValueReference valRef) {
            ArrayList<FieldsGenerator> results = new ArrayList<FieldsGenerator>();
            if (FacesJSPUtil.isVisibleValueRef(valRef) && FacesJSPUtil.isFacesPage(this.getDocument())) {
                FilePositionContext modelContext = new FilePositionContext(this.getDocument().getFile());
                if (valRef.getType((IModelContext)modelContext).getNumFields((IModelContext)modelContext) > 0) {
                    results.add(new PanelGridFieldsGenerator(this.getDocument()));
                } else {
                    results.add(new OutputTextFieldGenerator(this.getDocument()));
                }
            }
            return results;
        }
    }

    private class ExternalVariableProviderForJSF
    extends AbstractDocumentService
    implements IExternalVariableProvider {
        public ExternalVariableProviderForJSF(IDocument doc) {
            super(doc);
        }

        public List<ExternalVariable> getExternalVariables() {
            if (JSFTechnologyExtension.this.getVersion().compareTo(JSFVersion.V2_0.toString()) >= 0 ? !"jsp.JSPDocument".equals(this.getDocument().getDocumentType()) && !"jsf.FaceletDocument".equals(this.getDocument().getDocumentType()) : !"jsp.JSPDocument".equals(this.getDocument().getDocumentType())) {
                return Collections.emptyList();
            }
            IProject project = this.getDocument().getFile().getProject();
            ArrayList<ExternalVariable> extVars = new ArrayList<ExternalVariable>();
            IProjectVariablesCache cache = VariablesController.getInstance().getProjectCache(project);
            List vars = cache.getVariables();
            for (Variable var : vars) {
                if (!(var instanceof FacesExternalVariable) && !(var instanceof FacesBundleExternalVariable)) continue;
                extVars.add((ExternalVariable)var);
            }
            return Collections.unmodifiableList(extVars);
        }
    }

    private class ImplicitVariableProviderForJSF
    extends AbstractDocumentService
    implements IImplicitVariableProvider {
        public ImplicitVariableProviderForJSF(IDocument doc) {
            super(doc);
        }

        public List<Variable> getImplicitVariables() {
            ArrayList<Variable> ivs = new ArrayList<Variable>();
            String mapType = Map.class.getName();
            DefaultBuiltInSymbolProvider builtIns = DefaultBuiltInSymbolProvider.getInstance();
            ISymbol applicationScope = builtIns.getSymbol("applicationScope", (IAdaptable)this.getDocument().getFile(), 4);
            ISymbol sessionScope = builtIns.getSymbol("sessionScope", (IAdaptable)this.getDocument().getFile(), 2);
            ISymbol requestScope = builtIns.getSymbol("requestScope", (IAdaptable)this.getDocument().getFile(), 1);
            if (applicationScope instanceof IInstanceSymbol) {
                this.addImplicitVar(ivs, "applicationScope", (IInstanceSymbol)applicationScope, Variable.SCOPE.APPLICATION_SCOPE);
            } else {
                this.addImplicitVar(ivs, "applicationScope", mapType, Variable.SCOPE.APPLICATION_SCOPE);
            }
            this.addImplicitVar(ivs, "initParam", mapType, Variable.SCOPE.APPLICATION_SCOPE);
            if (sessionScope instanceof IInstanceSymbol) {
                this.addImplicitVar(ivs, "sessionScope", (IInstanceSymbol)sessionScope, Variable.SCOPE.SESSION_SCOPE);
            } else {
                this.addImplicitVar(ivs, "sessionScope", mapType, Variable.SCOPE.SESSION_SCOPE);
            }
            if (requestScope instanceof IInstanceSymbol) {
                this.addImplicitVar(ivs, "requestScope", (IInstanceSymbol)requestScope, Variable.SCOPE.REQUEST_SCOPE);
            } else {
                this.addImplicitVar(ivs, "requestScope", mapType, Variable.SCOPE.REQUEST_SCOPE);
            }
            this.addImplicitVar(ivs, "cookie", mapType, Variable.SCOPE.REQUEST_SCOPE);
            this.addImplicitVar(ivs, "header", mapType, Variable.SCOPE.REQUEST_SCOPE);
            this.addImplicitVar(ivs, "headerValues", mapType, Variable.SCOPE.REQUEST_SCOPE);
            this.addImplicitVar(ivs, "param", mapType, Variable.SCOPE.REQUEST_SCOPE);
            this.addImplicitVar(ivs, "paramValues", mapType, Variable.SCOPE.REQUEST_SCOPE);
            this.addImplicitVar(ivs, "facesContext", "javax.faces.context.FacesContext", Variable.SCOPE.REQUEST_SCOPE);
            this.addImplicitVar(ivs, "view", "javax.faces.component.UIViewRoot", Variable.SCOPE.REQUEST_SCOPE);
            if (JSFTechnologyExtension.this.getVersion().compareTo(JSFVersion.V2_0.toString()) >= 0) {
                ISymbol flash;
                ISymbol viewScope = builtIns.getSymbol("viewScope", (IAdaptable)this.getDocument().getFile(), 16);
                if (viewScope != null) {
                    if (viewScope instanceof IInstanceSymbol) {
                        this.addImplicitVar(ivs, "viewScope", (IInstanceSymbol)viewScope, Variable.SCOPE.VIEW_SCOPE);
                    } else {
                        this.addImplicitVar(ivs, "viewScope", mapType, Variable.SCOPE.VIEW_SCOPE);
                    }
                }
                if ((flash = builtIns.getSymbol("flash", (IAdaptable)this.getDocument().getFile(), 32)) != null) {
                    if (flash instanceof IInstanceSymbol) {
                        this.addImplicitVar(ivs, "flash", (IInstanceSymbol)flash, Variable.SCOPE.FLASH_SCOPE);
                    } else {
                        this.addImplicitVar(ivs, "flash", mapType, Variable.SCOPE.FLASH_SCOPE);
                    }
                }
                ISymbol symbol = builtIns.getSymbol("cc", (IAdaptable)this.getDocument().getFile(), 1);
                this.addImplicitVar(ivs, "cc", (IInstanceSymbol)symbol, Variable.SCOPE.REQUEST_SCOPE);
                symbol = builtIns.getSymbol("component", (IAdaptable)this.getDocument().getFile(), 1);
                this.addImplicitVar(ivs, "component", (IInstanceSymbol)symbol, Variable.SCOPE.REQUEST_SCOPE);
                symbol = builtIns.getSymbol("resource", (IAdaptable)this.getDocument().getFile(), 4);
                this.addImplicitVar(ivs, "resource", (IInstanceSymbol)symbol, Variable.SCOPE.APPLICATION_SCOPE);
            }
            ivs.addAll(DefaultImplicitImmediateVariableProvider.getInstance().getSymbols(this.getDocument().getFile(), this.getProject(), (IDatatypeProvider)this.getProject().getAppService(IDatatypeProvider.class)));
            return Collections.unmodifiableList(ivs);
        }

        private void addImplicitVar(List<Variable> ivs, String varName, IInstanceSymbol symbol, Variable.SCOPE scope) {
            Project project = this.getProject();
            if (project != null && symbol != null) {
                ivs.add((Variable)new JSFImplicitVariable(symbol, project, scope));
            }
        }

        private void addImplicitVar(List<Variable> ivs, String varName, String varType, Variable.SCOPE scope) {
            IDatatypeProvider dataTypeProvider;
            Project project = this.getProject();
            if (project != null && (dataTypeProvider = (IDatatypeProvider)project.getAppService(IDatatypeProvider.class)) != null) {
                DataType dt = dataTypeProvider.getDataType(varType, null);
                ivs.add((Variable)new ImplicitVariable(varName, dt, scope, ResolutionTime.PAGE_RUN));
            }
        }
    }

    private static class JSFFileVariablesCacheProvider
    implements IFileVariablesCacheProvider {
        private final IDocument document;

        public JSFFileVariablesCacheProvider(IDocument document) {
            this.document = document;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public IFileVariablesCache getCache(boolean useWorkingCopy) {
            return VariablesController.getInstance().getFileCache(this.document.getFile(), useWorkingCopy);
        }
    }
}

