/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.webtier.jsf.facelets.FaceletCompilerCache;
import oracle.eclipse.tools.webtier.jsf.tagsupport.IFaceletTagSymbolFactory;
import org.apache.myfaces.shared.util.ClassUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.webtier.jsf";
    private static Activator plugin;
    private FaceletCompilerCache faceletCompilerCache;
    private List<IFaceletTagSymbolFactory> faceletSymbolFactories = Collections.EMPTY_LIST;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initializeFaceletSymbolFactories();
        URL dtd = ClassUtils.getResource((String)"org/apache/myfaces/resource/default.dtd");
        this.faceletCompilerCache = new FaceletCompilerCache(dtd);
    }

    public void stop(BundleContext context) throws Exception {
        this.faceletCompilerCache.dispose();
        this.faceletCompilerCache = null;
        plugin = null;
        if (this.faceletSymbolFactories != Collections.EMPTY_LIST) {
            this.faceletSymbolFactories.clear();
            this.faceletSymbolFactories = Collections.EMPTY_LIST;
        }
        super.stop(context);
    }

    public FaceletCompilerCache getFaceletCompilerCache() {
        return this.faceletCompilerCache;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error in Oepe JSF plugin", e));
    }

    private void initializeFaceletSymbolFactories() {
        if (!Platform.isRunning()) {
            return;
        }
        try {
            this.faceletSymbolFactories = new ArrayList<IFaceletTagSymbolFactory>(2);
            Collection exts = PluginUtil.findExtensions((String)PLUGIN_ID, (String)"faceletTagContributor");
            for (IConfigurationElement element : PluginUtil.getTopLevelElements((Collection)exts)) {
                Object factory = element.createExecutableExtension("class");
                if (!(factory instanceof IFaceletTagSymbolFactory)) continue;
                this.faceletSymbolFactories.add((IFaceletTagSymbolFactory)factory);
            }
        }
        catch (Exception e) {
            Activator.log(e);
            return;
        }
    }

    public List<IFaceletTagSymbolFactory> getFaceletSymbolFactories() {
        if (this.faceletSymbolFactories.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.faceletSymbolFactories);
    }
}

