/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoveryProvider;
import oracle.eclipse.tools.common.services.project.technology.DefaultTechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.webtier.jsf.Activator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public abstract class AbstractJSFTechnologyDiscoverer
extends DefaultTechnologyDiscoverer {
    private final List<String> _expectedClass;
    private final List<String> _expectedNotPresentClasses;

    public AbstractJSFTechnologyDiscoverer(List<String> expectedClasses, List<String> expectedNotPresentClasses, AbstractTechnologyDiscoveryProvider technologyDiscoveryProvider, ITechnologyExtensionIdentifier techId) {
        super(technologyDiscoveryProvider, techId);
        this._expectedClass = expectedClasses;
        this._expectedNotPresentClasses = expectedNotPresentClasses;
    }

    public boolean isActive() {
        boolean isActive = super.isActive();
        try {
            Project project;
            IProject iProject;
            IJavaProject javaProj;
            if (!isActive && !FacetedProjectFramework.hasProjectFacet((IProject)this.getTechnologyDiscoveryProvider().getProject().getEclipseProject(), (String)this.getBaseFacet()) && (javaProj = JavaCore.create((IProject)(iProject = (project = this.getTechnologyDiscoveryProvider().getProject()).getEclipseProject()))) != null && javaProj.exists()) {
                boolean allClassesFound = true;
                for (String className : this._expectedClass) {
                    try {
                        allClassesFound &= javaProj.findType(className) != null;
                    }
                    catch (JavaModelException javaModelException) {
                        allClassesFound = false;
                    }
                }
                boolean allClassesNotFound = false;
                if (allClassesFound) {
                    allClassesNotFound = true;
                    for (String className : this._expectedNotPresentClasses) {
                        try {
                            allClassesNotFound &= javaProj.findType(className) == null;
                        }
                        catch (JavaModelException javaModelException) {
                            allClassesNotFound = false;
                        }
                    }
                }
                isActive = allClassesFound && allClassesNotFound;
            }
        }
        catch (CoreException ce) {
            Activator.log(ce);
            isActive = false;
        }
        return isActive;
    }

    protected String getBaseFacet() {
        return "jst.jsf";
    }

    public static class JSF11TechnologyDiscoverer
    extends AbstractJSFTechnologyDiscoverer {
        private static final List<String> EXPECTED_CLASSES = Collections.singletonList("javax.faces.render.RenderKit");
        private static final List<String> EXPECTED_NOT_FOUND_CLASSES = Collections.singletonList("javax.faces.component.html.HtmlColumn");

        public JSF11TechnologyDiscoverer(AbstractTechnologyDiscoveryProvider technologyDiscoveryProvider, ITechnologyExtensionIdentifier techId) {
            super(EXPECTED_CLASSES, EXPECTED_NOT_FOUND_CLASSES, technologyDiscoveryProvider, techId);
        }
    }

    public static class JSF12TechnologyDiscoverer
    extends AbstractJSFTechnologyDiscoverer {
        private static final List<String> EXPECTED_CLASSES_12;

        static {
            ArrayList<String> initExpectedClasses = new ArrayList<String>();
            initExpectedClasses.addAll(JSF11TechnologyDiscoverer.EXPECTED_CLASSES);
            initExpectedClasses.add("javax.faces.component.html.HtmlColumn");
            EXPECTED_CLASSES_12 = Collections.unmodifiableList(initExpectedClasses);
        }

        public JSF12TechnologyDiscoverer(AbstractTechnologyDiscoveryProvider technologyDiscoveryProvider, ITechnologyExtensionIdentifier techId) {
            super(EXPECTED_CLASSES_12, Collections.EMPTY_LIST, technologyDiscoveryProvider, techId);
        }
    }

    public static class JSF20TechnologyDiscoverer
    extends AbstractJSFTechnologyDiscoverer {
        private static final List<String> EXPECTED_CLASSES_20;
        private static List<String> UNEXPECTED_CLASSES_20;

        static {
            ArrayList<String> initExpectedClasses = new ArrayList<String>();
            initExpectedClasses.add("javax.faces.component.html.HtmlBody");
            EXPECTED_CLASSES_20 = Collections.unmodifiableList(initExpectedClasses);
            UNEXPECTED_CLASSES_20 = Collections.singletonList("javax.faces.view.facelets.FaceletCacheFactory");
        }

        public JSF20TechnologyDiscoverer(AbstractTechnologyDiscoveryProvider technologyDiscoveryProvider, ITechnologyExtensionIdentifier techId) {
            super(EXPECTED_CLASSES_20, UNEXPECTED_CLASSES_20, technologyDiscoveryProvider, techId);
        }
    }

    public static class JSF21TechnologyDiscoverer
    extends AbstractJSFTechnologyDiscoverer {
        private static final List<String> EXPECTED_CLASSES_21;
        private static List<String> UNEXPECTED_CLASSES_21;

        static {
            ArrayList<String> initExpectedClasses = new ArrayList<String>();
            initExpectedClasses.add("javax.faces.view.facelets.FaceletCacheFactory");
            EXPECTED_CLASSES_21 = Collections.unmodifiableList(initExpectedClasses);
            UNEXPECTED_CLASSES_21 = Collections.singletonList("javax.faces.flow.FlowHandlerFactory");
        }

        public JSF21TechnologyDiscoverer(AbstractTechnologyDiscoveryProvider technologyDiscoveryProvider, ITechnologyExtensionIdentifier techId) {
            super(EXPECTED_CLASSES_21, UNEXPECTED_CLASSES_21, technologyDiscoveryProvider, techId);
        }
    }

    public static class JSF22TechnologyDiscoverer
    extends AbstractJSFTechnologyDiscoverer {
        private static final List<String> EXPECTED_CLASSES_22;

        static {
            ArrayList<String> initExpectedClasses = new ArrayList<String>();
            initExpectedClasses.add("javax.faces.flow.FlowHandlerFactory");
            EXPECTED_CLASSES_22 = Collections.unmodifiableList(initExpectedClasses);
        }

        public JSF22TechnologyDiscoverer(AbstractTechnologyDiscoveryProvider technologyDiscoveryProvider, ITechnologyExtensionIdentifier techId) {
            super(EXPECTED_CLASSES_22, Collections.EMPTY_LIST, technologyDiscoveryProvider, techId);
        }
    }
}

