/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.ant.core;

import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.mylyn.docs.epub.ant.core.AntLogger;
import org.eclipse.mylyn.docs.epub.ant.core.ContributorType;
import org.eclipse.mylyn.docs.epub.ant.core.CoverType;
import org.eclipse.mylyn.docs.epub.ant.core.CoverageType;
import org.eclipse.mylyn.docs.epub.ant.core.CreatorType;
import org.eclipse.mylyn.docs.epub.ant.core.DateType;
import org.eclipse.mylyn.docs.epub.ant.core.FileSetType;
import org.eclipse.mylyn.docs.epub.ant.core.FormatType;
import org.eclipse.mylyn.docs.epub.ant.core.IdentifierType;
import org.eclipse.mylyn.docs.epub.ant.core.ItemType;
import org.eclipse.mylyn.docs.epub.ant.core.LanguageType;
import org.eclipse.mylyn.docs.epub.ant.core.MetaType;
import org.eclipse.mylyn.docs.epub.ant.core.PublisherType;
import org.eclipse.mylyn.docs.epub.ant.core.ReferenceType;
import org.eclipse.mylyn.docs.epub.ant.core.RelationType;
import org.eclipse.mylyn.docs.epub.ant.core.RightsType;
import org.eclipse.mylyn.docs.epub.ant.core.SourceType;
import org.eclipse.mylyn.docs.epub.ant.core.SubjectType;
import org.eclipse.mylyn.docs.epub.ant.core.TitleType;
import org.eclipse.mylyn.docs.epub.ant.core.TocType;
import org.eclipse.mylyn.docs.epub.ant.core.TypeType;
import org.eclipse.mylyn.docs.epub.core.EPUB;
import org.eclipse.mylyn.docs.epub.core.ILogger;
import org.eclipse.mylyn.docs.epub.core.OPSPublication;
import org.eclipse.mylyn.docs.epub.core.Publication;
import org.eclipse.mylyn.docs.epub.opf.Role;

public class EpubTask
extends Task {
    private Publication oebps = null;
    private ArrayList<FileSetType> filesets = null;
    private TocType toc = null;
    private File workingFolder;
    private File epubFile;
    private AntLogger logger;

    public EpubTask() {
        try {
            this.logger = new AntLogger(this);
            this.oebps = new OPSPublication((ILogger)this.logger);
            this.filesets = new ArrayList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addConfiguredContributor(ContributorType item) {
        if (item.role == null) {
            this.oebps.addContributor(item.id, item.lang, item.name, null, item.fileAs);
        } else {
            this.oebps.addContributor(item.id, item.lang, item.name, Role.get((String)item.role), item.fileAs);
        }
    }

    public void addConfiguredCover(CoverType item) {
        this.oebps.setCover(new File(item.image), item.value);
    }

    public void addConfiguredCoverage(CoverageType coverage) {
        this.oebps.addCoverage(coverage.id, coverage.lang, coverage.text);
    }

    public void addConfiguredCreator(CreatorType item) {
        if (item.role == null) {
            this.oebps.addCreator(item.id, item.lang, item.name, null, item.fileAs);
        } else {
            this.oebps.addCreator(item.id, item.lang, item.name, Role.get((String)item.role), item.fileAs);
        }
    }

    public void addConfiguredDate(DateType item) {
        this.oebps.addDate(item.id, item.date, item.event);
    }

    public void addConfiguredFileSet(FileSetType fs) {
        this.filesets.add(fs);
    }

    public void addConfiguredFormat(FormatType format) {
        this.oebps.addFormat(format.id, format.text);
    }

    public void addConfiguredIdentifier(IdentifierType identifier) {
        this.oebps.addIdentifier(identifier.id, identifier.scheme, identifier.value);
    }

    public void addConfiguredItem(ItemType item) {
        this.oebps.addItem(item.id, item.lang, item.file, item.dest, item.type, item.spine, item.linear, item.noToc);
    }

    public void addConfiguredLanguage(LanguageType language) {
        this.oebps.addLanguage(language.id, language.code);
    }

    public void addConfiguredMeta(MetaType item) {
        this.oebps.addMeta(item.name, item.content);
    }

    public void addConfiguredPublisher(PublisherType publisher) {
        this.oebps.addPublisher(publisher.id, publisher.lang, publisher.text);
    }

    public void addConfiguredReference(ReferenceType reference) {
        this.oebps.addReference(reference.href, reference.title, reference.type);
    }

    public void addConfiguredRelation(RelationType relation) {
        this.oebps.addRelation(relation.id, relation.lang, relation.text);
    }

    public void addConfiguredRights(RightsType rights) {
        this.oebps.addRights(rights.id, rights.lang, rights.text);
    }

    public void addConfiguredSource(SourceType source) {
        this.oebps.addSource(source.id, source.lang, source.text);
    }

    public void addConfiguredSubject(SubjectType subject) {
        this.oebps.addSubject(subject.id, subject.lang, subject.text);
    }

    public void addConfiguredTitle(TitleType title) {
        this.oebps.addTitle(title.id, title.lang, title.text);
    }

    public void addConfiguredToc(TocType toc) {
        if (this.toc != null) {
            throw new BuildException("Only one table of contents (toc) declaration is allowed.");
        }
        this.toc = toc;
    }

    public void addConfiguredType(TypeType type) {
        this.oebps.addType(type.id, type.text);
    }

    private void addFilesets() {
        for (FileSetType fs : this.filesets) {
            String[] includedFiles;
            File fsDir = fs.getDir(this.getProject());
            if (fsDir == null) {
                throw new BuildException("File or Resource without directory or file specified");
            }
            if (!fsDir.isDirectory()) {
                throw new BuildException("Directory does not exist:" + fsDir);
            }
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] stringArray = includedFiles = ds.getIncludedFiles();
            int n = includedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String includedFile = stringArray[n2];
                String filename = includedFile.replace('\\', '/');
                filename = filename.substring(filename.lastIndexOf(47) + 1);
                File base = ds.getBasedir();
                File found = new File(base, includedFile);
                this.oebps.addItem(null, fs.lang, found, fs.dest, null, false, true, false);
                ++n2;
            }
        }
    }

    public void execute() throws BuildException {
        if (this.getProject() == null) {
            Project project = new Project();
            this.setProject(project);
        }
        this.addFilesets();
        if (this.toc != null) {
            if (this.toc.generate) {
                this.oebps.setGenerateToc(true);
            } else if (this.toc.file != null) {
                this.oebps.setTableOfContents(this.toc.file);
            }
        }
        try {
            EPUB epub = new EPUB((ILogger)this.logger);
            epub.add(this.oebps);
            if (this.workingFolder == null) {
                epub.pack(this.epubFile);
            } else {
                epub.pack(this.epubFile, this.workingFolder);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setIncludeReferenced(boolean automatic) {
        this.oebps.setIncludeReferencedResources(automatic);
    }

    public void setFile(File file) {
        this.epubFile = file;
    }

    public void setIdentifierId(String identifierId) {
        this.oebps.setIdentifierId(identifierId);
    }

    public void setWorkingFolder(File workingFolder) {
        this.workingFolder = workingFolder;
    }
}

