/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython;

import java.util.List;
import org.eclipse.core.runtime.AssertionFailedException;
import org.python.pydev.parser.jython.ISpecialStr;
import org.python.pydev.parser.jython.Node;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.Token;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.structure.LowMemoryArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNode
implements Node,
ISimpleNode {
    private static final boolean DEBUG = false;
    public int beginLine;
    public int beginColumn;
    public SimpleNode parent;
    public List<Object> specialsBefore;
    public List<Object> specialsAfter;
    private int nodeId = -1;

    public int getId() {
        return this.nodeId;
    }

    public void setId(int id) {
        this.nodeId = id;
    }

    public Object getImage() {
        return null;
    }

    public void setImage(Object image) {
    }

    public SimpleNode createCopy() {
        throw new RuntimeException("Subclasses must reimplement");
    }

    public SimpleNode createCopy(boolean copyComments) {
        throw new RuntimeException("Subclasses must reimplement");
    }

    public void addSpecial(Object special, boolean after) {
        if (special != null) {
            if (special instanceof Token) {
                special = ((Token)special).asSpecialStr();
            } else if (special instanceof String) {
                throw new AssertionFailedException("assertion failed: Special: " + special + " is not valid");
            }
            if (after) {
                if (special instanceof commentType) {
                    this.getSpecialsAfter().add(special);
                } else {
                    int addAt = this.countAfter(special, false);
                    this.getSpecialsAfter().add(addAt, special);
                }
            } else if (special instanceof commentType) {
                commentType s = (commentType)special;
                if (s.beginLine < this.beginLine) {
                    this.getSpecialsBefore().add(this.countBefore(special, true), special);
                } else {
                    this.getSpecialsBefore().add(special);
                }
            } else {
                int addAt = this.countBefore(special, false);
                this.getSpecialsBefore().add(addAt, special);
            }
        }
    }

    public List<Object> getSpecialsBefore() {
        if (this.specialsBefore == null) {
            this.specialsBefore = new LowMemoryArrayList();
        }
        return this.specialsBefore;
    }

    public List<Object> getSpecialsAfter() {
        if (this.specialsAfter == null) {
            this.specialsAfter = new LowMemoryArrayList();
        }
        return this.specialsAfter;
    }

    private int countStrings() {
        return this.doCountStringsAndSpecialStrings(this.specialsAfter);
    }

    private int countStringsBefore() {
        return this.doCountStringsAndSpecialStrings(this.specialsBefore);
    }

    private int countAfter(Object special, boolean beforeRegularStrings) {
        int[] lineCol = this.getLineCol(special);
        if (lineCol == null) {
            return this.countStrings();
        }
        return this.getIndex(lineCol, this.specialsAfter, beforeRegularStrings);
    }

    private int countBefore(Object special, boolean beforeRegularStrings) {
        int[] lineCol = this.getLineCol(special);
        if (lineCol == null) {
            return this.countStringsBefore();
        }
        return this.getIndex(lineCol, this.specialsBefore, beforeRegularStrings);
    }

    private int getIndex(int[] lineCol, List<Object> l, boolean beforeRegularStrings) {
        if (l == null) {
            return 0;
        }
        int i = 0;
        for (Object o : l) {
            int[] existing = this.getLineCol(o);
            if (existing == null) {
                if (beforeRegularStrings) {
                    return i;
                }
            } else {
                if (existing[0] > lineCol[0]) {
                    return i;
                }
                if (existing[0] == lineCol[0] && existing[1] > lineCol[1]) {
                    return i;
                }
            }
            ++i;
        }
        return i;
    }

    private int[] getLineCol(Object o) {
        if (o instanceof ISpecialStr) {
            ISpecialStr s = (ISpecialStr)o;
            return new int[]{s.getBeginLine(), s.getBeginCol()};
        }
        if (o instanceof commentType) {
            commentType c = (commentType)o;
            return new int[]{c.beginLine, c.beginColumn};
        }
        return null;
    }

    private int doCountStringsAndSpecialStrings(List<Object> l) {
        if (l == null) {
            return 0;
        }
        int i = 0;
        for (Object o : l) {
            if (!(o instanceof String) && !(o instanceof ISpecialStr)) continue;
            ++i;
        }
        return i;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " at line " + this.beginLine;
    }

    public String toString(String prefix) {
        return String.valueOf(prefix) + this.toString();
    }

    public Object accept(VisitorIF visitor) throws Exception {
        throw new ParseException("Unexpected node: " + this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        throw new ParseException("Unexpected node: " + this);
    }

    protected String dumpThis(String s) {
        return s;
    }

    protected String dumpThis(Object o) {
        return String.valueOf(o);
    }

    protected String dumpThis(Object[] s) {
        StringBuffer sb = new StringBuffer();
        if (s == null) {
            sb.append("null");
        } else {
            sb.append("[");
            int i = 0;
            while (i < s.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(s[i]));
                ++i;
            }
            sb.append("]");
        }
        return sb.toString();
    }

    protected String dumpThis(int i) {
        return Integer.toString(i);
    }

    protected String dumpThis(int i, String[] names) {
        if (i >= names.length || i < 0) {
            return "Unknown (out of bounds)";
        }
        return names[i];
    }

    protected String dumpThis(int[] arr, String[] names) {
        StringBuffer sb = new StringBuffer();
        if (arr == null) {
            sb.append("null");
        } else {
            sb.append("[");
            int i = 0;
            while (i < arr.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(names[arr[i]]);
                ++i;
            }
            sb.append("]");
        }
        return sb.toString();
    }

    protected String dumpThis(boolean b) {
        return String.valueOf(b);
    }
}

