/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.parser.PyParser;
import org.python.pydev.shared_core.editor.IBaseEditor;
import org.python.pydev.shared_core.parsing.BaseParserManager;
import org.python.pydev.shared_core.parsing.IParser;

public class PyParserManager
extends BaseParserManager {
    public static final String USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE = "USE_PYDEV_ONLY_ON_DOC_SAVE";
    public static final String PYDEV_ELAPSE_BEFORE_ANALYSIS = "PYDEV_ELAPSE_BEFORE_ANALYSIS";
    private IPreferenceStore prefs;
    private static PyParserManager pyParserManager;

    public static synchronized PyParserManager getPyParserManager(IPreferenceStore prefs) {
        if (pyParserManager == null) {
            pyParserManager = new PyParserManager(prefs);
        }
        return pyParserManager;
    }

    public static synchronized void setPyParserManager(PyParserManager pyParserManager) {
        PyParserManager.pyParserManager = pyParserManager;
    }

    private PyParserManager(IPreferenceStore prefs) {
        Assert.isNotNull((Object)prefs);
        this.prefs = prefs;
        this.millisBeforeAnalysis = prefs.getInt(PYDEV_ELAPSE_BEFORE_ANALYSIS);
        this.useOnlyOnSave = prefs.getBoolean(USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE);
        IPropertyChangeListener prefListener = new IPropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals(PyParserManager.USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE) || property.equals(PyParserManager.PYDEV_ELAPSE_BEFORE_ANALYSIS)) {
                    PyParserManager.this.millisBeforeAnalysis = PyParserManager.this.prefs.getInt(PyParserManager.PYDEV_ELAPSE_BEFORE_ANALYSIS);
                    PyParserManager.this.useOnlyOnSave = PyParserManager.this.prefs.getBoolean(PyParserManager.USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE);
                    boolean useAnalysisOnlyOnDocSave = PyParserManager.this.useAnalysisOnlyOnDocSave();
                    Object object = PyParserManager.this.lock;
                    synchronized (object) {
                        for (IParser parser : PyParserManager.this.parsers.keySet()) {
                            parser.resetTimeoutPreferences(useAnalysisOnlyOnDocSave);
                        }
                    }
                }
            }
        };
        this.prefs.addPropertyChangeListener(prefListener);
    }

    protected IParser createParser(IBaseEditor edit) {
        return new PyParser((IPyEdit)edit);
    }
}

