/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.doc.online.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.doc.online.OracleOnlineResource;
import oracle.eclipse.tools.common.doc.online.OracleOnlineResources;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class OracleOnlineResourcesContributionItem
extends ContributionItem {
    private final OracleOnlineResource.Type type;

    public OracleOnlineResourcesContributionItem(OracleOnlineResource.Type type) {
        this.type = type;
    }

    public void fill(Menu menu, int index) {
        boolean first = true;
        for (List<OracleOnlineResource> group : this.getOnlineResources()) {
            if (first) {
                first = false;
            } else {
                new MenuItem(menu, 2);
            }
            for (OracleOnlineResource resource : group) {
                this.createMenuItemForResource(menu, resource);
            }
        }
    }

    protected List<List<OracleOnlineResource>> getOnlineResources() {
        ArrayList<OracleOnlineResource> resources = new ArrayList<OracleOnlineResource>();
        resources.addAll(OracleOnlineResources.getOnlineResources(this.type));
        Collections.sort(resources, new OracleOnlineResource.ByNameComparator());
        return Collections.singletonList(resources);
    }

    protected final void createMenuItemForResource(Menu menu, final OracleOnlineResource resource) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText(resource.getName());
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                resource.open();
            }
        });
        ImageDescriptor imageDescriptor = resource.getImageDescriptor();
        if (imageDescriptor != null) {
            final Image image = imageDescriptor.createImage();
            item.setImage(image);
            menu.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    image.dispose();
                }
            });
        }
    }
}

