/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.doc.online;

import java.net.URL;
import java.util.Comparator;
import oracle.eclipse.tools.common.doc.OracleDocsPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;

public final class OracleOnlineResource {
    private final String id;
    private final Type type;
    private final String name;
    private final URL url;

    public OracleOnlineResource(String id, Type type, String name, URL url) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.url = url;
    }

    public String getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.type == Type.WEBSITE) {
            return OracleDocsPlugin.IMG_DESC_ORACLE_WEBSITE;
        }
        if (this.type == Type.FORUM) {
            return OracleDocsPlugin.IMG_DESC_ORACLE_FORUM;
        }
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    public void open() {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(this.url);
        }
        catch (Exception e) {
            OracleDocsPlugin.log(e);
        }
    }

    public static final class ByNameComparator
    implements Comparator<OracleOnlineResource> {
        @Override
        public int compare(OracleOnlineResource x, OracleOnlineResource y) {
            return x.name.compareTo(y.name);
        }
    }

    public static enum Type {
        WEBSITE,
        FORUM;

    }
}

