/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.wst.internet.monitor.core.internal.ContentFilter;
import org.eclipse.wst.internet.monitor.core.internal.IContentFilter;
import org.eclipse.wst.internet.monitor.core.internal.IStartup;
import org.eclipse.wst.internet.monitor.core.internal.ProtocolAdapter;
import org.eclipse.wst.internet.monitor.core.internal.Trace;
import org.osgi.framework.BundleContext;

public class MonitorPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.internet.monitor.core";
    private static MonitorPlugin singleton;
    protected Map<String, ProtocolAdapter> protocolAdapters;
    protected Map<String, IContentFilter> contentFilters;
    protected boolean startupsLoaded;

    public MonitorPlugin() {
        singleton = this;
        this.loadProtocolAdapters();
        this.loadContentFilters();
    }

    public static MonitorPlugin getInstance() {
        return singleton;
    }

    public String getDefaultType() {
        return "HTTP";
    }

    public ProtocolAdapter getProtocolAdapter(String id) {
        return this.protocolAdapters.get(id);
    }

    public ProtocolAdapter[] getProtocolAdapters() {
        ArrayList<ProtocolAdapter> list = new ArrayList<ProtocolAdapter>();
        Iterator<ProtocolAdapter> iterator = this.protocolAdapters.values().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        ProtocolAdapter[] types = new ProtocolAdapter[list.size()];
        list.toArray(types);
        return types;
    }

    public IContentFilter[] getContentFilters() {
        ArrayList<IContentFilter> list = new ArrayList<IContentFilter>();
        Iterator<IContentFilter> iterator = this.contentFilters.values().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        IContentFilter[] cf = new IContentFilter[list.size()];
        list.toArray(cf);
        return cf;
    }

    public IContentFilter findContentFilter(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        return this.contentFilters.get(id);
    }

    protected synchronized void loadProtocolAdapters() {
        if (this.protocolAdapters != null) {
            return;
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "Loading protocol adapters");
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "internalProtocolAdapters");
        int size = cf.length;
        HashMap<String, ProtocolAdapter> map = new HashMap<String, ProtocolAdapter>(size);
        int i = 0;
        while (i < size) {
            String id = cf[i].getAttribute("id");
            if (Trace.CONFIG) {
                Trace.trace("/config", "Loading adapter: " + id);
            }
            map.put(id, new ProtocolAdapter(cf[i]));
            ++i;
        }
        this.protocolAdapters = map;
    }

    protected synchronized void loadContentFilters() {
        if (this.contentFilters != null) {
            return;
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "Loading content filters");
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "internalContentFilters");
        int size = cf.length;
        HashMap<String, IContentFilter> map = new HashMap<String, IContentFilter>(size);
        int i = 0;
        while (i < size) {
            String id = cf[i].getAttribute("id");
            if (Trace.CONFIG) {
                Trace.trace("/config", "Loading filter: " + id);
            }
            map.put(id, new ContentFilter(cf[i]));
            ++i;
        }
        this.contentFilters = map;
    }

    protected synchronized void executeStartups() {
        if (this.startupsLoaded) {
            return;
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "Loading startups");
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "internalStartup");
        int size = cf.length;
        int i = 0;
        while (i < size) {
            block9: {
                String id = cf[i].getAttribute("id");
                if (Trace.CONFIG) {
                    Trace.trace("/config", "Loading startup: " + id);
                }
                try {
                    IStartup startup = (IStartup)cf[i].createExecutableExtension("class");
                    try {
                        startup.startup();
                    }
                    catch (Exception ex) {
                        if (Trace.SEVERE) {
                            Trace.trace("/severe", "Startup failed" + startup.toString(), ex);
                        }
                    }
                }
                catch (Exception e) {
                    if (!Trace.SEVERE) break block9;
                    Trace.trace("/severe", "Could not create startup: " + id, e);
                }
            }
            ++i;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        props.put("listener.symbolic.name", PLUGIN_ID);
        context.registerService(DebugOptionsListener.class.getName(), (Object)new Trace(), props);
    }
}

