/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.SSECoreMessages;
import org.eclipse.wst.sse.core.internal.SSECorePlugin;
import org.eclipse.wst.sse.core.internal.tasks.WorkspaceTaskScanner;
import org.eclipse.wst.sse.core.utils.StringUtils;

class TaskScanningJob
extends Job {
    static final int JOB_DELAY_DELTA = 1000;
    private static final int JOB_DELAY_PROJECT = 5000;
    static final String TASK_TAG_PROJECTS_ALREADY_SCANNED = "task-tag-projects-already-scanned";
    static final IPath TASK_TAG_PROJECTS_ALREADY_SCANNED_LOCATION = SSECorePlugin.getDefault().getStateLocation().append("task-tags.properties");
    static final QualifiedName QTASK_TAG_PROJECTS_ALREADY_SCANNED = new QualifiedName("org.eclipse.wst.sse.core", "task-tag-projects-already-scanned");
    private List fQueue = new ArrayList();
    private static final String OSGI_FRAMEWORK_ID = "org.eclipse.osgi";

    TaskScanningJob() {
        super(SSECoreMessages.TaskScanner_0);
        this.setPriority(50);
        this.setSystem(true);
        this.setUser(false);
    }

    synchronized void addProjectDelta(IResourceDelta delta) {
        IResource projectResource = delta.getResource();
        if (projectResource.getType() == 4) {
            if (!projectResource.isAccessible()) {
                String[] projectsPreviouslyScanned = TaskScanningJob.getScannedProjects();
                HashSet<String> updatedProjects = new HashSet<String>(Arrays.asList(projectsPreviouslyScanned));
                updatedProjects.remove(projectResource.getName());
                TaskScanningJob.setScannedProjects(updatedProjects.toArray(new String[updatedProjects.size()]));
            }
            if (this.isEnabledOnProject((IProject)projectResource)) {
                if (delta.getFlags() == 16384) {
                    this.addProject((IProject)projectResource);
                } else {
                    this.fQueue.add(delta);
                }
                if (Logger.DEBUG_TASKSJOB) {
                    String kind = null;
                    switch (delta.getKind()) {
                        case 1: {
                            kind = " [IResourceDelta.ADDED]";
                            break;
                        }
                        case 4: {
                            kind = " [IResourceDelta.CHANGED]";
                            break;
                        }
                        case 2: {
                            kind = " [IResourceDelta.REMOVED]";
                            break;
                        }
                        case 8: {
                            kind = " [IResourceDelta.ADDED_PHANTOM]";
                            break;
                        }
                        case 16: {
                            kind = " [IResourceDelta.REMOVED_PHANTOM]";
                        }
                    }
                    System.out.println("Adding delta " + delta.getFullPath() + kind);
                }
                this.schedule(1000L);
            }
        }
    }

    synchronized void addProject(IProject project) {
        if (this.projectHasNotBeenFullyScanned((IResource)project)) {
            this.fQueue.add(project);
            if (Logger.DEBUG_TASKSJOB) {
                System.out.println("Adding project " + project.getName());
            }
            this.schedule(5000L);
        }
    }

    boolean frameworkIsShuttingDown() {
        boolean shuttingDown;
        boolean bl = shuttingDown = !Platform.isRunning() || Platform.getBundle((String)OSGI_FRAMEWORK_ID).getState() == 16;
        if (Logger.DEBUG_TASKSJOB && shuttingDown) {
            System.out.println("TaskScanningJob: system is shutting down!");
        }
        return shuttingDown;
    }

    private boolean isEnabledOnProject(IProject p) {
        IPreferencesService preferencesService = Platform.getPreferencesService();
        IScopeContext[] lookupOrder = new IScopeContext[]{new ProjectScope(p), new InstanceScope(), new DefaultScope()};
        return preferencesService.getBoolean("org.eclipse.wst.sse.core/task-tags", "enabled", false, lookupOrder);
    }

    private boolean projectHasNotBeenFullyScanned(IResource project) {
        String[] projectsScanned = TaskScanningJob.getScannedProjects();
        boolean shouldScan = true;
        String name = project.getName();
        int j = 0;
        while (shouldScan && j < projectsScanned.length) {
            if (projectsScanned[j].equals(name)) {
                if (Logger.DEBUG_TASKSJOB) {
                    System.out.println("Scanning Job skipping " + project.getName());
                }
                shouldScan = false;
            }
            ++j;
        }
        return shouldScan;
    }

    synchronized List retrieveQueue() {
        List queue = this.fQueue;
        this.fQueue = new ArrayList();
        return queue;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.frameworkIsShuttingDown()) {
            return Status.CANCEL_STATUS;
        }
        this.cleanupRememberedProjectList();
        IStatus status = null;
        List currentQueue = this.retrieveQueue();
        try {
            Thread.currentThread().setPriority(1);
        }
        catch (SecurityException securityException) {}
        ArrayList<Status> errors = null;
        int ticks = currentQueue.size();
        String taskName = null;
        taskName = Logger.DEBUG_TASKSJOB ? String.valueOf(SSECoreMessages.TaskScanningJob_0) + " (" + ticks + " work items)" : SSECoreMessages.TaskScanningJob_0;
        monitor.beginTask(taskName, ticks);
        SubProgressMonitor scanMonitor = null;
        while (!currentQueue.isEmpty()) {
            Object o = currentQueue.remove(0);
            if (this.frameworkIsShuttingDown() || monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                HashSet<String> updatedProjects;
                String[] projectsPreviouslyScanned;
                scanMonitor = new SubProgressMonitor(monitor, 1, 4);
                if (o instanceof IResourceDelta) {
                    WorkspaceTaskScanner.getInstance().scan((IResourceDelta)o, (IProgressMonitor)scanMonitor);
                    continue;
                }
                if (!(o instanceof IProject)) continue;
                WorkspaceTaskScanner.getInstance().scan((IProject)o, (IProgressMonitor)scanMonitor);
                if (!scanMonitor.isCanceled()) {
                    projectsPreviouslyScanned = TaskScanningJob.getScannedProjects();
                    updatedProjects = new HashSet<String>(Arrays.asList(projectsPreviouslyScanned));
                    updatedProjects.add(((IProject)o).getName());
                    TaskScanningJob.setScannedProjects(updatedProjects.toArray(new String[updatedProjects.size()]));
                }
                if (((IProject)o).isAccessible()) continue;
                projectsPreviouslyScanned = TaskScanningJob.getScannedProjects();
                updatedProjects = new HashSet<String>(Arrays.asList(projectsPreviouslyScanned));
                updatedProjects.remove(((IProject)o).getName());
                TaskScanningJob.setScannedProjects(updatedProjects.toArray(new String[updatedProjects.size()]));
            }
            catch (Exception e) {
                if (errors == null) {
                    errors = new ArrayList<Status>();
                }
                errors.add(new Status(4, "org.eclipse.wst.sse.core", 4, "", (Throwable)e));
            }
        }
        monitor.done();
        if (errors == null || errors.isEmpty()) {
            status = Status.OK_STATUS;
        } else if (errors.size() == 1) {
            status = (IStatus)errors.get(0);
        } else {
            IStatus[] statii = errors.toArray(new IStatus[errors.size()]);
            status = new MultiStatus("org.eclipse.wst.sse.core", 4, statii, SSECoreMessages.TaskScanningJob_1, null);
        }
        SSECorePlugin.getDefault().savePluginPreferences();
        return status;
    }

    private void cleanupRememberedProjectList() {
        String[] rememberedProjectNames = TaskScanningJob.getScannedProjects();
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        String[] projectNames = new String[workspaceProjects.length];
        int i = 0;
        while (i < projectNames.length) {
            projectNames[i] = workspaceProjects[i].getName();
            ++i;
        }
        ArrayList<String> projectNamesToRemember = new ArrayList<String>(rememberedProjectNames.length);
        int i2 = 0;
        while (i2 < rememberedProjectNames.length) {
            boolean rememberedProjectExists = false;
            int j = 0;
            while (!rememberedProjectExists && j < projectNames.length) {
                if (rememberedProjectNames[i2].equals(projectNames[j])) {
                    rememberedProjectExists = true;
                }
                ++j;
            }
            if (rememberedProjectExists) {
                projectNamesToRemember.add(rememberedProjectNames[i2]);
            } else if (Logger.DEBUG_TASKSJOB) {
                System.out.println("Removing " + rememberedProjectNames[i2] + " removed from " + TASK_TAG_PROJECTS_ALREADY_SCANNED);
            }
            ++i2;
        }
        if (projectNamesToRemember.size() != rememberedProjectNames.length) {
            TaskScanningJob.setScannedProjects(projectNamesToRemember.toArray(new String[projectNamesToRemember.size()]));
        }
    }

    static String[] getScannedProjects() {
        String rawValue = null;
        File file = TASK_TAG_PROJECTS_ALREADY_SCANNED_LOCATION.toFile();
        if (file.canRead()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(file));
                rawValue = props.getProperty(TASK_TAG_PROJECTS_ALREADY_SCANNED);
                props = null;
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        if (rawValue != null) {
            return StringUtils.unpack(rawValue);
        }
        return new String[0];
    }

    static void setScannedProjects(String[] projectNames) {
        File file;
        if (Logger.DEBUG_TASKSJOB) {
            System.out.println("Task scanned projects set to " + StringUtils.pack(projectNames));
        }
        if (!(file = TASK_TAG_PROJECTS_ALREADY_SCANNED_LOCATION.toFile()).exists() || file.canWrite()) {
            Properties props = new Properties();
            props.setProperty(TASK_TAG_PROJECTS_ALREADY_SCANNED, StringUtils.pack(projectNames));
            try {
                props.store(new FileOutputStream(file), "");
            }
            catch (IOException e) {
                Logger.logException(e);
            }
            props = null;
        } else {
            Logger.log(2, "Could not write task tags scanned list to " + TASK_TAG_PROJECTS_ALREADY_SCANNED_LOCATION.toOSString());
        }
    }
}

