/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.transformer;

import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalTransformer<I, O>
implements Transformer<I, O> {
    private final ThreadLocal<Transformer<? super I, ? extends O>> threadLocal;
    private final Transformer<? super I, ? extends O> defaultTransformer;

    public ThreadLocalTransformer(Transformer<? super I, ? extends O> defaultTransformer) {
        if (defaultTransformer == null) {
            throw new NullPointerException();
        }
        this.defaultTransformer = defaultTransformer;
        this.threadLocal = this.buildThreadLocal();
    }

    private ThreadLocal<Transformer<? super I, ? extends O>> buildThreadLocal() {
        return new ThreadLocal<Transformer<? super I, ? extends O>>();
    }

    @Override
    public O transform(I input) {
        return this.get().transform(input);
    }

    private Transformer<? super I, ? extends O> get() {
        Transformer<? super I, ? extends O> transformer = this.threadLocal.get();
        if (transformer != null) {
            return transformer;
        }
        return this.defaultTransformer;
    }

    public void set(Transformer<? super I, ? extends O> transformer) {
        this.threadLocal.set(transformer);
    }

    public String toString() {
        return this.get().toString();
    }
}

