/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.predicate;

import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullCheckPredicateWrapper<V>
implements Predicate<V> {
    private final Predicate<? super V> predicate;
    private final boolean nullValue;

    public NullCheckPredicateWrapper(Predicate<? super V> predicate, boolean nullValue) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        this.predicate = predicate;
        this.nullValue = nullValue;
    }

    @Override
    public boolean evaluate(V variable) {
        return variable == null ? this.nullValue : this.predicate.evaluate(variable);
    }

    public boolean equals(Object o) {
        if (!(o instanceof NullCheckPredicateWrapper)) {
            return false;
        }
        NullCheckPredicateWrapper other = (NullCheckPredicateWrapper)o;
        return this.predicate.equals(other.predicate) && this.nullValue == other.nullValue;
    }

    public int hashCode() {
        return this.predicate.hashCode() ^ Boolean.valueOf(this.nullValue).hashCode();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.nullValue);
    }
}

