/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.node;

import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.node.Node;

public class DefaultNodeProblem
implements Node.Problem {
    private final Node source;
    private final String messageKey;
    private final int messageType;
    private final Object[] messageArguments;

    DefaultNodeProblem(Node source, String messageKey, int messageType, Object[] messageArguments) {
        if (source == null || messageKey == null || messageArguments == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.messageKey = messageKey;
        this.messageType = messageType;
        this.messageArguments = messageArguments;
    }

    public Node source() {
        return this.source;
    }

    public String messageKey() {
        return this.messageKey;
    }

    public int messageType() {
        return this.messageType;
    }

    public Object[] messageArguments() {
        return this.messageArguments;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node.Problem)) {
            return false;
        }
        Node.Problem other = (Node.Problem)o;
        return this.source == other.source() && this.messageKey.equals(other.messageKey()) && Arrays.equals(this.messageArguments, other.messageArguments());
    }

    public int hashCode() {
        return this.source.hashCode() ^ this.messageKey.hashCode();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.messageKey);
    }
}

